/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.Utils;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.data.cache.CacheService;

public class LocalCacheService
implements CacheService {
    public static final CacheService instance = new LocalCacheService();
    private int _defaultSeconds;
    private final Map<String, Entity> _data = new ConcurrentHashMap<String, Entity>();
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();

    public LocalCacheService() {
        this(30);
    }

    public LocalCacheService(int defSeconds) {
        this._defaultSeconds = defSeconds;
    }

    public LocalCacheService(Properties prop) {
        String defSeconds_str = prop.getProperty("defSeconds");
        if (Utils.isNotEmpty((String)defSeconds_str)) {
            this._defaultSeconds = Integer.parseInt(defSeconds_str);
        }
        if (this._defaultSeconds < 1) {
            this._defaultSeconds = 30;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String key, Object obj, int seconds) {
        if (seconds <= 0) {
            seconds = this.getDefalutSeconds();
        }
        this.SYNC_LOCK.lock();
        try {
            Entity ent = this._data.get(key);
            if (ent == null) {
                ent = new Entity(obj);
                this._data.put(key, ent);
            } else {
                ent.value = obj;
                ent.futureDel();
            }
            if (seconds > 0) {
                ent.future = RunUtil.delay(() -> this._data.remove(key), (long)((long)seconds * 1000L));
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    @Override
    public <T> T get(String key, Class<T> clz) {
        Entity ent = this._data.get(key);
        return (T)(ent == null ? null : ent.value);
    }

    @Override
    public void remove(String key) {
        this.SYNC_LOCK.lock();
        try {
            Entity ent = this._data.remove(key);
            if (ent != null) {
                ent.futureDel();
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void clear() {
        for (Entity ent : this._data.values()) {
            ent.futureDel();
        }
        this._data.clear();
    }

    public int getDefalutSeconds() {
        return this._defaultSeconds;
    }

    private static class Entity {
        public Object value;
        public Future future;

        public Entity(Object val) {
            this.value = val;
        }

        protected void futureDel() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }
}

