/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.data.annotation.Cache;
import org.noear.solon.data.annotation.CachePut;
import org.noear.solon.data.annotation.CacheRemove;
import org.noear.solon.data.cache.CacheLib;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.CacheTags;
import org.noear.solon.data.util.InvKeys;
import org.noear.solon.data.util.StringMutexLock;

public class CacheExecutorImp {
    public static final CacheExecutorImp global = new CacheExecutorImp();
    private final StringMutexLock SYNC_LOCK = new StringMutexLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cache(Cache anno, Invocation inv, SupplierEx executor) throws Throwable {
        if (anno == null) {
            return executor.get();
        }
        String key = anno.key();
        key = Utils.isEmpty((String)key) ? InvKeys.buildByInv(inv) : InvKeys.buildByTmlAndInv(key, inv);
        Object result = null;
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        this.SYNC_LOCK.lock(key);
        try {
            result = cs.get(key, inv.method().getReturnType());
            if (result == null && (result = executor.get()) != null) {
                cs.store(key, result, anno.seconds());
                if (Utils.isNotEmpty((String)anno.tags())) {
                    String tags = InvKeys.buildByTmlAndInv(anno.tags(), inv, result);
                    CacheTags ct = new CacheTags(cs);
                    for (String tag : tags.split(",")) {
                        ct.add(tag, key, anno.seconds());
                    }
                }
            }
            Object object = result;
            return object;
        }
        finally {
            this.SYNC_LOCK.unlock(key);
        }
    }

    public void cacheRemove(CacheRemove anno, Invocation inv, Object rstValue) {
        if (anno == null) {
            return;
        }
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        if (Utils.isNotEmpty((String)anno.keys())) {
            String keys = InvKeys.buildByTmlAndInv(anno.keys(), inv, rstValue);
            for (String key : keys.split(",")) {
                cs.remove(key);
            }
        }
        if (Utils.isNotEmpty((String)anno.tags())) {
            String tags = InvKeys.buildByTmlAndInv(anno.tags(), inv, rstValue);
            CacheTags ct = new CacheTags(cs);
            for (String tag : tags.split(",")) {
                ct.remove(tag);
            }
        }
    }

    public void cachePut(CachePut anno, Invocation inv, Object rstValue) {
        if (anno == null) {
            return;
        }
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        if (Utils.isNotEmpty((String)anno.key())) {
            String key = InvKeys.buildByTmlAndInv(anno.key(), inv, rstValue);
            cs.store(key, rstValue, anno.seconds());
        }
        if (Utils.isNotEmpty((String)anno.tags())) {
            String tags = InvKeys.buildByTmlAndInv(anno.tags(), inv, rstValue);
            CacheTags ct = new CacheTags(cs);
            for (String tag : tags.split(",")) {
                ct.update(tag, rstValue, anno.seconds());
            }
        }
    }
}

