/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.TreeMap;

public class MethodUtil {
    public static boolean allowMethod(Method element) {
        int modifiers = element.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers);
    }

    public static String buildMethodKey(Method method) {
        StringBuilder buf = new StringBuilder();
        buf.append(method.getName());
        buf.append("(");
        for (Parameter pe : method.getParameters()) {
            Class<?> pet = pe.getType();
            buf.append(pet.toString());
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    public static Map<String, Method> findMethodAll(Class<?> type) {
        TreeMap<String, Method> methodAll = new TreeMap<String, Method>();
        for (Method method : type.getDeclaredMethods()) {
            if (!MethodUtil.allowMethod(method)) continue;
            String methodKey = MethodUtil.buildMethodKey(method);
            methodAll.put(methodKey, method);
        }
        for (Class<?> origin = type.getSuperclass(); origin != Object.class; origin = origin.getSuperclass()) {
            for (Method method : origin.getDeclaredMethods()) {
                if (!MethodUtil.allowMethod(method)) continue;
                String methodKey = MethodUtil.buildMethodKey(method);
                methodAll.putIfAbsent(methodKey, method);
            }
        }
        return methodAll;
    }
}

