/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.test.aot;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.noear.solon.Solon;
import org.noear.solon.aot.RuntimeNativeMetadata;
import org.noear.solon.aot.graalvm.GraalvmUtil;
import org.noear.solon.aot.hint.JdkProxyHint;
import org.noear.solon.aot.hint.SerializationHint;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.util.ReflectUtil;
import org.noear.solon.test.aot.NativeMetadataReflectAssert;

public abstract class RuntimeNativeMetadataAssert {
    private static NativeMetadataReflectAssert REFLECT_ASSERT;

    public static NativeMetadataReflectAssert reflect() {
        if (REFLECT_ASSERT == null) {
            REFLECT_ASSERT = new NativeMetadataReflectAssert();
        }
        return REFLECT_ASSERT;
    }

    public static void hasSerializationType(Class<?> type) {
        SerializationHint serializationHint = (SerializationHint)RuntimeNativeMetadataAssert.getMetadata().getSerializations().get(ReflectUtil.getClassName(type));
        RuntimeNativeMetadataAssert.notNull(serializationHint, String.format("serialization type '%s' not found in native metadata", type.getName()));
    }

    public static void hasSerializationType(String className) {
        SerializationHint serializationHint = (SerializationHint)RuntimeNativeMetadataAssert.getMetadata().getSerializations().get(className);
        RuntimeNativeMetadataAssert.notNull(serializationHint, String.format("serialization type '%s' not found in native metadata", className));
    }

    public static void hasLambdaSerializationType(Class<?> type) {
        SerializationHint serializationHint = (SerializationHint)RuntimeNativeMetadataAssert.getMetadata().getLambdaSerializations().get(ReflectUtil.getClassName(type));
        RuntimeNativeMetadataAssert.notNull(serializationHint, String.format("lambda serialization type '%s' not found in native metadata", type.getName()));
    }

    public static void hasLambdaSerializationType(String className) {
        SerializationHint serializationHint = (SerializationHint)RuntimeNativeMetadataAssert.getMetadata().getLambdaSerializations().get(className);
        RuntimeNativeMetadataAssert.notNull(serializationHint, String.format("lambda serialization type '%s' not found in native metadata", className));
    }

    public static void hasJdkProxyType(Class<?> type) {
        JdkProxyHint jdkProxyHint = (JdkProxyHint)RuntimeNativeMetadataAssert.getMetadata().getJdkProxys().get(ReflectUtil.getClassName(type));
        RuntimeNativeMetadataAssert.notNull(jdkProxyHint, String.format("jdk proxy type '%s' not found in native metadata", type.getName()));
    }

    public static void hasJdkProxyType(String className) {
        JdkProxyHint jdkProxyHint = (JdkProxyHint)RuntimeNativeMetadataAssert.getMetadata().getJdkProxys().get(className);
        RuntimeNativeMetadataAssert.notNull(jdkProxyHint, String.format("jdk proxy type '%s' not found in native metadata", className));
    }

    public static void resourceIsInclude(String resource) {
        Set resources = GraalvmUtil.getResources();
        RuntimeNativeMetadataAssert.assertTrue(resources.contains(resource), String.format("resource '%s' not found in native metadata", resource));
    }

    protected static RuntimeNativeMetadata getMetadata() {
        AppContext context = Solon.context();
        if (context == null) {
            throw new IllegalArgumentException("solon app not initialized");
        }
        return (RuntimeNativeMetadata)context.getBean(RuntimeNativeMetadata.class);
    }

    protected static Method getMethod(Class<?> type, String methodName) {
        List methods = Arrays.stream(ReflectUtil.getDeclaredMethods(type)).filter(method -> method.getName().equals(methodName)).collect(Collectors.toList());
        if (methods.size() == 1) {
            return (Method)methods.iterator().next();
        }
        if (methods.size() > 1) {
            throw new IllegalArgumentException(String.format("Found multiple methods named '%s' on class %s", methodName, type.getName()));
        }
        throw new IllegalArgumentException(String.format("No method named '%s' on class %s", methodName, type.getName()));
    }

    protected static Field findField(Class<?> clazz, String name) {
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectUtil.getDeclaredFields(searchType)) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    protected static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new AssertionError((Object)message);
        }
    }

    protected static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    protected static void hasText(String text, String message) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }
}

