/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.http.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.noear.solon.Utils;

public class HttpStream {
    private final String contentType;
    private InputStream content;
    private File file;

    public HttpStream(InputStream content, String type) {
        this.contentType = type;
        this.content = content;
    }

    public HttpStream(String filename, File file) {
        this.contentType = Utils.mime((String)filename);
        this.file = file;
    }

    public InputStream getContent() throws IOException {
        if (this.content == null) {
            this.content = new FileInputStream(this.file);
        }
        return this.content;
    }

    public long getContentLength() throws IOException {
        if (this.file != null) {
            return this.file.length();
        }
        return this.content.available();
    }

    public String getContentType() {
        return this.contentType;
    }
}

