/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.utils;

import java.io.Reader;
import java.lang.reflect.Constructor;
import java.sql.Clob;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.snack.core.utils.StringUtil;
import org.noear.snack.exception.SnackException;

public class BeanUtil {
    private static final Map<String, Class<?>> clzCached = new ConcurrentHashMap();
    private static final Map<Class<?>, Object> insCached = new ConcurrentHashMap();

    public static boolean isEmpty(Collection s) {
        return s == null || s.size() == 0;
    }

    public static boolean isEmpty(Map s) {
        return s == null || s.size() == 0;
    }

    @Deprecated
    public static Class<?> loadClass(String clzName) {
        if (StringUtil.isEmpty(clzName)) {
            return null;
        }
        return clzCached.computeIfAbsent(clzName, k -> {
            try {
                return Class.forName(k);
            }
            catch (Throwable e) {
                throw new SnackException("Failed to load class: " + clzName, e);
            }
        });
    }

    public static String clobToString(Clob clob) {
        Reader reader = null;
        StringBuilder buf = new StringBuilder();
        try {
            int len;
            reader = clob.getCharacterStream();
            char[] chars = new char[2048];
            while ((len = reader.read(chars, 0, chars.length)) >= 0) {
                buf.append(chars, 0, len);
            }
        }
        catch (Throwable e) {
            throw new SnackException("Read string from reader error", e);
        }
        String text = buf.toString();
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Throwable e) {
                throw new SnackException("Read string from reader error", e);
            }
        }
        return text;
    }

    public static Object getInstance(Class<?> clz) {
        return insCached.computeIfAbsent(clz, k -> BeanUtil.newInstance(k));
    }

    public static Object newInstance(Class<?> clz) throws SnackException {
        try {
            if (clz.isInterface()) {
                return null;
            }
            return clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new SnackException("Instantiation failed: " + clz.getName(), e);
        }
    }

    public static Object newInstance(Constructor constructor, Object[] args) throws SnackException {
        if (constructor == null) {
            throw new IllegalArgumentException("constructor is null");
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Throwable e) {
            throw new SnackException("Instantiation failed: " + constructor.getDeclaringClass().getName(), e);
        }
    }
}

