/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import org.noear.snack.ONode;
import org.noear.snack.OValueType;
import org.noear.snack.core.Feature;
import org.noear.snack.core.utils.DateUtil;
import org.noear.snack.core.utils.StringUtil;
import org.noear.snack.exception.SnackException;

public class OValue {
    protected String _string;
    protected boolean _bool;
    protected Date _date;
    protected Number _number;
    protected ONode _n;
    private OValueType _type = OValueType.Null;

    public OValue(ONode n) {
        this._n = n;
    }

    public OValueType type() {
        return this._type;
    }

    public void set(Object val) {
        if (val == null) {
            this._type = OValueType.Null;
            return;
        }
        if (val instanceof String) {
            this.setString((String)val);
            return;
        }
        if (val instanceof Date) {
            this.setDate((Date)val);
            return;
        }
        if (val instanceof Number) {
            this.setNumber((Number)val);
            return;
        }
        if (val instanceof Boolean) {
            this.setBool((Boolean)val);
            return;
        }
        throw new SnackException("Unsupport type, class: " + val.getClass().getName());
    }

    public void setNull() {
        this._type = OValueType.Null;
    }

    public void setNumber(Number val) {
        this._type = OValueType.Number;
        this._number = val;
    }

    public void setString(String val) {
        this._type = OValueType.String;
        this._string = val;
    }

    public void setBool(boolean val) {
        this._type = OValueType.Boolean;
        this._bool = val;
    }

    public void setDate(Date val) {
        this._type = OValueType.DateTime;
        this._date = val;
    }

    public Object getRaw() {
        switch (this._type) {
            case String: {
                return this._string;
            }
            case DateTime: {
                return this._date;
            }
            case Boolean: {
                return this._bool;
            }
            case Number: {
                return this._number;
            }
        }
        return null;
    }

    public String getRawString() {
        return this._string;
    }

    public boolean getRawBoolean() {
        return this._bool;
    }

    public Date getRawDate() {
        return this._date;
    }

    public Number getRawNumber() {
        return this._number;
    }

    public boolean isNull() {
        return this._type == OValueType.Null;
    }

    public boolean isEmpty() {
        if (this._type == OValueType.String) {
            return StringUtil.isEmpty(this._string);
        }
        return this.isNull();
    }

    public char getChar() {
        switch (this._type) {
            case Number: {
                return (char)this._number.longValue();
            }
            case String: {
                if (this._string == null || this._string.length() == 0) {
                    return '\u0000';
                }
                return this._string.charAt(0);
            }
            case Boolean: {
                return this._bool ? (char)'1' : '0';
            }
            case DateTime: {
                return '\u0000';
            }
        }
        return '\u0000';
    }

    public short getShort() {
        return (short)this.getLong();
    }

    public int getInt() {
        return (int)this.getLong();
    }

    public long getLong() {
        switch (this._type) {
            case Number: {
                return this._number.longValue();
            }
            case String: {
                if (this._string == null || this._string.length() == 0) {
                    return 0L;
                }
                return Long.parseLong(this._string);
            }
            case Boolean: {
                return this._bool ? 1L : 0L;
            }
            case DateTime: {
                return this._date.getTime();
            }
        }
        return 0L;
    }

    public float getFloat() {
        return (float)this.getDouble();
    }

    public double getDouble() {
        switch (this._type) {
            case Number: {
                return this._number.doubleValue();
            }
            case String: {
                if (this._string == null || this._string.length() == 0) {
                    return 0.0;
                }
                return Double.parseDouble(this._string);
            }
            case Boolean: {
                return this._bool ? 1.0 : 0.0;
            }
            case DateTime: {
                return this._date.getTime();
            }
        }
        return 0.0;
    }

    public String getString() {
        switch (this._type) {
            case String: {
                return this._string;
            }
            case Number: {
                if (this._number instanceof BigInteger) {
                    return this._number.toString();
                }
                if (this._number instanceof BigDecimal) {
                    return ((BigDecimal)this._number).toPlainString();
                }
                return String.valueOf(this._number);
            }
            case Boolean: {
                return String.valueOf(this._bool);
            }
            case DateTime: {
                return String.valueOf(this._date);
            }
        }
        if (this._n._o.hasFeature(Feature.StringNullAsEmpty)) {
            return "";
        }
        return null;
    }

    public boolean getBoolean() {
        switch (this._type) {
            case Boolean: {
                return this._bool;
            }
            case Number: {
                return this._number.intValue() > 0;
            }
            case String: {
                return "true".equals(this._string) || "True".equals(this._string);
            }
            case DateTime: {
                return false;
            }
        }
        return false;
    }

    public Date getDate() {
        switch (this._type) {
            case DateTime: {
                return this._date;
            }
            case String: {
                if (this._string == null) {
                    return null;
                }
                return this.parseDate(this._string.trim());
            }
            case Number: {
                return new Date(this._number.longValue());
            }
        }
        return null;
    }

    private Date parseDate(String dateString) {
        try {
            return DateUtil.parse(dateString);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public String toString() {
        return this.getString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return this.isNull();
        }
        if (o instanceof OValue) {
            OValue o2 = (OValue)o;
            switch (this._type) {
                case String: {
                    return this._string.equals(o2._string);
                }
                case DateTime: {
                    return this._date.equals(o2._date);
                }
                case Boolean: {
                    return this._bool == o2._bool;
                }
                case Number: {
                    if (this._number instanceof BigInteger) {
                        return this.toString().equals(o2.toString());
                    }
                    if (this._number instanceof BigDecimal) {
                        return this.toString().equals(o2.toString());
                    }
                    if (this._number instanceof Double || this._number instanceof Float) {
                        return this.getDouble() == o2.getDouble();
                    }
                    return this.getLong() == o2.getLong();
                }
            }
            return this.isNull() && o2.isNull();
        }
        switch (this._type) {
            case String: {
                return this._string.equals(o);
            }
            case DateTime: {
                return this._date.equals(o);
            }
            case Boolean: {
                if (o instanceof Boolean) {
                    return this._bool == (Boolean)o;
                }
                return false;
            }
            case Number: {
                if (o instanceof Number) {
                    Number o2 = (Number)o;
                    if (this._number instanceof BigInteger) {
                        return this.toString().equals(o2.toString());
                    }
                    if (this._number instanceof BigDecimal) {
                        return this.toString().equals(o2.toString());
                    }
                    if (this._number instanceof Double || this._number instanceof Float) {
                        return this._number.doubleValue() == o2.doubleValue();
                    }
                    return this._number.longValue() == o2.longValue();
                }
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        switch (this._type) {
            case String: {
                return this._string.hashCode();
            }
            case DateTime: {
                return this._date.hashCode();
            }
            case Boolean: {
                return Boolean.hashCode(this._bool);
            }
            case Number: {
                return this._number.hashCode();
            }
        }
        return 0;
    }
}

