/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.smartboot.http.common.Reset;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.enums.HttpTypeEnum;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.io.BodyInputStream;
import org.smartboot.http.common.io.ChunkedInputStream;
import org.smartboot.http.common.io.PostInputStream;
import org.smartboot.http.common.io.ReadListener;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.server.Http2ServerHandler;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.impl.CommonRequest;
import org.smartboot.http.server.impl.DecoderUnit;
import org.smartboot.http.server.impl.Http2Session;
import org.smartboot.http.server.impl.HttpRequestImpl;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.socket.timer.HashedWheelTimer;
import org.smartboot.socket.timer.TimerTask;
import org.smartboot.socket.transport.AioSession;

public final class Request
extends CommonRequest
implements Reset {
    private static final Logger LOGGER = LoggerFactory.getLogger(Request.class);
    private static final int INIT_CONTENT_LENGTH = -2;
    private static final int NONE_CONTENT_LENGTH = -1;
    private final DecoderUnit decodeState = new DecoderUnit();
    private ReadListener listener;
    private HttpTypeEnum type = null;
    private HttpRequestImpl httpRequest;
    private Http2Session http2Request;
    private WebSocketRequestImpl webSocketRequest;
    private ServerHandler serverHandler;
    private long remainingThreshold;
    private long latestIo;
    private TimerTask httpIdleTask;
    private TimerTask wsIdleTask;
    private BodyInputStream inputStream;
    private Map<String, String> trailerFields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelHttpIdleTask() {
        Request request = this;
        synchronized (request) {
            if (this.httpIdleTask != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("cancel http idle monitor, request:{}", (Object)this);
                }
                this.httpIdleTask.cancel();
                this.httpIdleTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelWsIdleTask() {
        Request request = this;
        synchronized (request) {
            if (this.wsIdleTask != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("cancel websocket idle monitor, request:{}", (Object)this);
                }
                this.wsIdleTask.cancel();
                this.wsIdleTask = null;
            }
        }
    }

    Request(HttpServerConfiguration configuration, AioSession aioSession) {
        super(aioSession, configuration);
        this.remainingThreshold = configuration.getMaxRequestSize();
        if (configuration.getWsIdleTimeout() > 0L) {
            this.wsIdleTask = HashedWheelTimer.DEFAULT_TIMER.scheduleWithFixedDelay(() -> {
                LOGGER.debug("check wsIdle monitor");
                if (System.currentTimeMillis() - this.latestIo > configuration.getWsIdleTimeout() && this.webSocketRequest != null) {
                    LOGGER.debug("close ws connection by idle monitor");
                    try {
                        aioSession.close();
                    }
                    finally {
                        this.cancelWsIdleTask();
                        this.cancelHttpIdleTask();
                    }
                }
            }, configuration.getWsIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        if (configuration.getHttpIdleTimeout() > 0L) {
            this.httpIdleTask = HashedWheelTimer.DEFAULT_TIMER.scheduleWithFixedDelay(() -> {
                LOGGER.debug("check httpIdle monitor");
                if (System.currentTimeMillis() - this.latestIo > configuration.getHttpIdleTimeout() && this.webSocketRequest == null) {
                    LOGGER.debug("close http connection by idle monitor");
                    try {
                        aioSession.close();
                    }
                    finally {
                        this.cancelHttpIdleTask();
                        this.cancelWsIdleTask();
                    }
                }
            }, configuration.getHttpIdleTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    public void setInputStream(BodyInputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public BodyInputStream getInputStream() {
        long contentLength;
        if (this.inputStream != null) {
            return this.inputStream;
        }
        this.inputStream = HeaderValueEnum.CHUNKED.getName().equalsIgnoreCase(this.getHeader(HeaderNameEnum.TRANSFER_ENCODING)) ? new ChunkedInputStream(this.aioSession, this.remainingThreshold, stringStringMap -> {
            this.trailerFields = stringStringMap;
        }) : ((contentLength = this.getContentLength()) > 0L ? new PostInputStream(this.aioSession, contentLength, this.remainingThreshold) : BodyInputStream.EMPTY_INPUT_STREAM);
        return this.inputStream;
    }

    @Override
    public AioSession getAioSession() {
        return this.aioSession;
    }

    void decodeSize(int size) {
        this.remainingThreshold -= (long)size;
        if (this.remainingThreshold < 0L) {
            throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
        }
    }

    @Override
    public HttpTypeEnum getRequestType() {
        if (this.type != null) {
            return this.type;
        }
        this.type = this.serverHandler instanceof WebSocketHandler ? HttpTypeEnum.WEBSOCKET : (this.serverHandler instanceof Http2ServerHandler ? HttpTypeEnum.HTTP_2 : HttpTypeEnum.HTTP);
        return this.type;
    }

    @Override
    public void setType(HttpTypeEnum type) {
        this.type = type;
    }

    @Override
    public ServerHandler getServerHandler() {
        return this.serverHandler;
    }

    @Override
    public void setServerHandler(ServerHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    @Override
    public String getRemoteAddr() {
        if (this.remoteAddr != null) {
            return this.remoteAddr;
        }
        try {
            InetSocketAddress remote = this.aioSession.getRemoteAddress();
            InetAddress address = remote.getAddress();
            this.remoteAddr = address == null ? remote.getHostString() : address.getHostAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.remoteAddr;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        try {
            return this.aioSession.getRemoteAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        try {
            return this.aioSession.getLocalAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getRemoteHost() {
        if (this.remoteHost != null) {
            return this.remoteHost;
        }
        try {
            this.remoteHost = this.aioSession.getRemoteAddress().getHostString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.remoteHost;
    }

    public HttpRequestImpl newHttpRequest() {
        if (this.httpRequest == null) {
            this.httpRequest = new HttpRequestImpl(this);
            this.cancelWsIdleTask();
        }
        return this.httpRequest;
    }

    public Http2Session newHttp2Session() {
        if (this.http2Request == null) {
            this.http2Request = new Http2Session(this);
            this.cancelWsIdleTask();
        }
        return this.http2Request;
    }

    public WebSocketRequestImpl newWebsocketRequest() {
        if (this.webSocketRequest == null) {
            this.webSocketRequest = new WebSocketRequestImpl(this);
            this.cancelHttpIdleTask();
        }
        return this.webSocketRequest;
    }

    public Map<String, String> getTrailerFields() {
        return this.trailerFields;
    }

    public void setLatestIo(long latestIo) {
        this.latestIo = latestIo;
    }

    public DecoderUnit getDecodeState() {
        return this.decodeState;
    }

    @Override
    public void reset() {
        super.reset();
        this.remainingThreshold = this.configuration.getMaxRequestSize();
        this.method = null;
        this.httpRequest = null;
        this.webSocketRequest = null;
        this.decodeState.setState(14);
        this.trailerFields = null;
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.inputStream = null;
        }
    }
}

