/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.handler;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.common.utils.AntPathMatcher;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.impl.Request;

public final class HttpRouteHandler
extends HttpServerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRouteHandler.class);
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
    private final HttpServerHandler defaultHandler;
    private final Map<String, HttpServerHandler> handlerMap = new ConcurrentHashMap<String, HttpServerHandler>();

    public HttpRouteHandler() {
        this(new HttpServerHandler(){

            @Override
            public void handle(HttpRequest request, HttpResponse response) throws IOException {
                response.setHttpStatus(HttpStatus.NOT_FOUND);
            }
        });
    }

    public HttpRouteHandler(HttpServerHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public void onHeaderComplete(Request request) throws IOException {
        HttpServerHandler httpServerHandler = this.matchHandler(request.getRequestURI());
        request.getConfiguration().getUriByteTree().addNode(request.getUri(), (Object)httpServerHandler);
        request.setServerHandler(httpServerHandler);
        httpServerHandler.onHeaderComplete(request);
    }

    public void onClose(Request request) {
        LOGGER.warn("connection is closed before route match.");
        this.defaultHandler.onClose(request);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, CompletableFuture<Object> completableFuture) throws Throwable {
        if (request.getProtocol() != HttpProtocolEnum.HTTP_2) {
            throw new UnsupportedOperationException();
        }
        HttpServerHandler httpServerHandler = this.matchHandler(request.getRequestURI());
        httpServerHandler.handle(request, response, completableFuture);
    }

    public HttpRouteHandler route(String urlPattern, HttpServerHandler httpHandler) {
        this.handlerMap.put(urlPattern, httpHandler);
        return this;
    }

    private HttpServerHandler matchHandler(String uri) {
        if (uri == null) {
            return this.defaultHandler;
        }
        HttpServerHandler httpHandler = this.handlerMap.get(uri);
        if (httpHandler == null) {
            for (Map.Entry<String, HttpServerHandler> entity : this.handlerMap.entrySet()) {
                if (!PATH_MATCHER.match(entity.getKey(), uri)) continue;
                httpHandler = entity.getValue();
                break;
            }
            if (httpHandler == null) {
                httpHandler = this.defaultHandler;
            }
        }
        return httpHandler;
    }
}

