/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.annotation.ValueFor;

public class AnnotationInfo {
    private String annotationName;
    private Annotation annotation;
    private Map<String, String> elements;

    private static String convert(Method element, Object value) {
        Class<?> returnType = element.getReturnType();
        if (returnType.isPrimitive()) {
            return String.valueOf(value);
        }
        if (returnType.equals(Class.class)) {
            return ((Class)value).getName();
        }
        String result = value.toString();
        if (result.isEmpty()) {
            if (element.getDefaultValue().toString().isEmpty()) {
                return null;
            }
            return element.getDefaultValue().toString();
        }
        return result;
    }

    public AnnotationInfo(Annotation annotation) {
        Method[] declaredElements;
        this.annotationName = annotation.annotationType().getName();
        this.annotation = annotation;
        this.elements = new HashMap<String, String>();
        for (Method element : declaredElements = annotation.annotationType().getDeclaredMethods()) {
            Object value = AnnotationInfo.getAttributeValue(annotation, element);
            this.elements.put(element.getName(), value != null ? AnnotationInfo.convert(element, value) : element.getDefaultValue().toString());
        }
        for (Method element : declaredElements) {
            Object value;
            ValueFor valueFor = element.getAnnotation(ValueFor.class);
            if (valueFor == null || (value = AnnotationInfo.getAttributeValue(annotation, element)) == null || value instanceof String && !StringUtils.isNotBlank((CharSequence)((String)value))) continue;
            this.elements.put(valueFor.value(), AnnotationInfo.convert(element, value));
        }
    }

    private static Object getAttributeValue(Annotation annotation, Method element) {
        return AccessController.doPrivileged(() -> {
            try {
                element.setAccessible(true);
                return element.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Could not read value of Annotation " + element.getName(), e);
            }
        });
    }

    public String getName() {
        return this.annotationName;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public String get(String key, String defaultValue) {
        this.elements.putIfAbsent(key, defaultValue);
        return this.get(key);
    }

    public String get(String key) {
        return this.elements.get(key);
    }
}

