/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.Collections;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.BuiltInFunctions;
import org.neo4j.cypherdsl.core.DistinctExpression;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ExpressionList;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class FunctionInvocation
implements Expression {
    private final String functionName;
    private final TypedSubtree<?> arguments;

    public static FunctionInvocation create(FunctionDefinition definition) {
        return new FunctionInvocation(definition.getImplementationName(), new Expression[0]);
    }

    public static FunctionInvocation create(FunctionDefinition definition, Expression ... expressions) {
        String message = "The expression for " + definition.getImplementationName() + "() is required.";
        Assertions.notEmpty(expressions, message);
        Assertions.notNull(expressions[0], message);
        return new FunctionInvocation(definition.getImplementationName(), expressions);
    }

    public static FunctionInvocation createDistinct(FunctionDefinition definition, Expression ... expressions) {
        Assertions.isTrue(definition.isAggregate(), "The distinct operator can only be applied within aggregate functions.");
        String message = "The expression for " + definition.getImplementationName() + "() is required.";
        Assertions.notEmpty(expressions, message);
        Assertions.notNull(expressions[0], message);
        Expression[] newExpressions = new Expression[expressions.length];
        newExpressions[0] = new DistinctExpression(expressions[0]);
        System.arraycopy(expressions, 1, newExpressions, 1, expressions.length - 1);
        return new FunctionInvocation(definition.getImplementationName(), newExpressions);
    }

    public static FunctionInvocation create(FunctionDefinition definition, PatternElement pattern) {
        Assertions.notNull(pattern, "The pattern for " + definition.getImplementationName() + "() is required.");
        return new FunctionInvocation(definition.getImplementationName(), new Pattern(Collections.singletonList(pattern)));
    }

    static FunctionInvocation create(FunctionDefinition definition, TypedSubtree<?> arguments) {
        Assertions.notNull(arguments, definition.getImplementationName() + "() requires at least one argument.");
        return new FunctionInvocation(definition.getImplementationName(), arguments);
    }

    private FunctionInvocation(String functionName, Expression ... arguments) {
        this.functionName = functionName;
        this.arguments = new ExpressionList(arguments);
    }

    private <T extends TypedSubtree<?>> FunctionInvocation(String functionName, T pattern) {
        this.functionName = functionName;
        this.arguments = pattern;
    }

    @API(status=API.Status.INTERNAL)
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.arguments.accept(visitor);
        visitor.leave(this);
    }

    public String toString() {
        return "FunctionInvocation{functionName='" + this.functionName + '\'' + '}';
    }

    @API(status=API.Status.EXPERIMENTAL, since="2020.1.0")
    public static interface FunctionDefinition {
        public String getImplementationName();

        default public boolean isAggregate() {
            return Arrays.stream(BuiltInFunctions.Aggregates.values()).map(BuiltInFunctions.Aggregates::getImplementationName).anyMatch(v -> v.equalsIgnoreCase(this.getImplementationName()));
        }
    }
}

