/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.connection.values.Node;
import org.neo4j.bolt.connection.values.Path;
import org.neo4j.bolt.connection.values.Segment;
import org.neo4j.bolt.connection.values.ValueFactory;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.value.BoltValue;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.UnsupportedDateTimeValue;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

public class BoltValueFactory
implements ValueFactory {
    private static final BoltValueFactory INSTANCE = new BoltValueFactory();

    public static BoltValueFactory getInstance() {
        return INSTANCE;
    }

    private BoltValueFactory() {
    }

    public org.neo4j.bolt.connection.values.Value value(Object value) {
        return ((InternalValue)Values.value(value)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(boolean value) {
        return ((InternalValue)Values.value(value)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(long value) {
        return ((InternalValue)Values.value(value)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(double value) {
        return ((InternalValue)Values.value(value)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(byte[] values) {
        if (values == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(values)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(String value) {
        if (value == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(value)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(Map<String, org.neo4j.bolt.connection.values.Value> stringToValue) {
        if (stringToValue == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(stringToValue)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(org.neo4j.bolt.connection.values.Value[] values) {
        if (values == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(values)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(Node node) {
        if (node == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(node)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(org.neo4j.bolt.connection.values.Relationship relationship) {
        if (relationship == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(relationship)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(Path path) {
        if (path == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(path)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(LocalDate localDate) {
        if (localDate == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(localDate)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(OffsetTime offsetTime) {
        if (offsetTime == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(offsetTime)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(LocalTime localTime) {
        if (localTime == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(localTime)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(localDateTime)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(offsetDateTime)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(zonedDateTime)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(Period period) {
        if (period == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(period)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value value(Duration duration) {
        if (duration == null) {
            return this.value((Object)null);
        }
        return ((InternalValue)Values.value(duration)).asBoltValue();
    }

    public Node node(long id, String elementId, Collection<String> labels, Map<String, org.neo4j.bolt.connection.values.Value> properties) {
        return new InternalNode(id, elementId, labels, this.toDriverMap(properties));
    }

    public org.neo4j.bolt.connection.values.Relationship relationship(long id, String elementId, long start, String startElementId, long end, String endElementId, String type, Map<String, org.neo4j.bolt.connection.values.Value> properties) {
        return new InternalRelationship(id, elementId, start, startElementId, end, endElementId, type, this.toDriverMap(properties));
    }

    public Segment segment(Node start, org.neo4j.bolt.connection.values.Relationship relationship, Node end) {
        return new InternalPath.SelfContainedSegment((InternalNode)start, (InternalRelationship)relationship, (InternalNode)end);
    }

    public Path path(List<Segment> segments, List<Node> nodes, List<org.neo4j.bolt.connection.values.Relationship> relationships) {
        List<Path.Segment> segments0 = segments.stream().map(segment -> (Path.Segment)segment).toList();
        List<org.neo4j.driver.types.Node> nodes0 = nodes.stream().map(node -> (org.neo4j.driver.types.Node)node).toList();
        List<Relationship> relationships0 = relationships.stream().map(relationship -> (Relationship)relationship).toList();
        return new InternalPath(segments0, nodes0, relationships0);
    }

    public org.neo4j.bolt.connection.values.Value isoDuration(long months, long days, long seconds, int nanoseconds) {
        return ((InternalValue)Values.isoDuration(months, days, seconds, nanoseconds)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value point(int srid, double x, double y) {
        return ((InternalValue)Values.point(srid, x, y)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value point(int srid, double x, double y, double z) {
        return ((InternalValue)Values.point(srid, x, y, z)).asBoltValue();
    }

    public org.neo4j.bolt.connection.values.Value unsupportedDateTimeValue(DateTimeException e) {
        return new UnsupportedDateTimeValue(e).asBoltValue();
    }

    public Map<String, org.neo4j.bolt.connection.values.Value> toBoltMap(Map<String, Value> map) {
        HashMap<String, BoltValue> result = new HashMap<String, BoltValue>(map.size());
        for (Map.Entry<String, Value> entry : map.entrySet()) {
            BoltValue boltValue = ((InternalValue)entry.getValue()).asBoltValue();
            result.put(entry.getKey(), boltValue);
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, Value> toDriverMap(Map<String, org.neo4j.bolt.connection.values.Value> map) {
        HashMap<String, Value> result = new HashMap<String, Value>(map.size());
        for (Map.Entry<String, org.neo4j.bolt.connection.values.Value> entry : map.entrySet()) {
            Value boltValue = ((BoltValue)entry.getValue()).asDriverValue();
            result.put(entry.getKey(), boltValue);
        }
        return Collections.unmodifiableMap(result);
    }
}

