/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.connection.DirectConnection;
import org.neo4j.driver.internal.messaging.request.MultiDatabaseUtil;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;

public class DirectConnectionProvider
implements ConnectionProvider {
    private final BoltServerAddress address;
    private final ConnectionPool connectionPool;

    DirectConnectionProvider(BoltServerAddress address, ConnectionPool connectionPool) {
        this.address = address;
        this.connectionPool = connectionPool;
    }

    @Override
    public CompletionStage<Connection> acquireConnection(ConnectionContext context) {
        return this.acquireConnection().thenApply(connection -> new DirectConnection((Connection)connection, context.databaseName(), context.mode()));
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.acquireConnection().thenCompose(Connection::release);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionPool.close();
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb() {
        return this.acquireConnection().thenCompose(conn -> {
            boolean supportsMultiDatabase = MultiDatabaseUtil.supportsMultiDatabase(conn);
            return conn.release().thenApply(ignored -> supportsMultiDatabase);
        });
    }

    public BoltServerAddress getAddress() {
        return this.address;
    }

    private CompletionStage<Connection> acquireConnection() {
        return this.connectionPool.acquire(this.address);
    }
}

