/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.logging;

import io.netty.channel.Channel;
import java.util.ResourceBundle;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelAttributes;

public class ChannelActivityLogger
implements System.Logger {
    private final Channel channel;
    private final String localChannelId;
    private final System.Logger delegate;
    private String dbConnectionId;
    private String serverAddress;

    public ChannelActivityLogger(Channel channel, LoggingProvider logging, Class<?> owner) {
        this(channel, logging.getLog(owner));
    }

    private ChannelActivityLogger(Channel channel, System.Logger delegate) {
        this.channel = channel;
        this.delegate = delegate;
        this.localChannelId = channel != null ? channel.id().toString() : null;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        return this.delegate.isLoggable(level);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
        this.delegate.log(level, bundle, this.reformat(msg), thrown);
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
        this.delegate.log(level, bundle, this.reformat(format), params);
    }

    String reformat(String message) {
        if (this.channel == null) {
            return message;
        }
        String dbConnectionId = this.getDbConnectionId();
        String serverAddress = this.getServerAddress();
        return String.format("[0x%s][%s][%s] %s", this.localChannelId, ChannelActivityLogger.valueOrEmpty(serverAddress), ChannelActivityLogger.valueOrEmpty(dbConnectionId), message);
    }

    private String getDbConnectionId() {
        if (this.dbConnectionId == null) {
            this.dbConnectionId = ChannelAttributes.connectionId(this.channel);
        }
        return this.dbConnectionId;
    }

    private String getServerAddress() {
        if (this.serverAddress == null) {
            BoltServerAddress serverAddress = ChannelAttributes.serverAddress(this.channel);
            this.serverAddress = serverAddress != null ? serverAddress.toString() : null;
        }
        return this.serverAddress;
    }

    private static String valueOrEmpty(String value) {
        return value != null ? value : "";
    }
}

