/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.handlers;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.bolt.connection.netty.impl.spi.ResponseHandler;
import org.neo4j.bolt.connection.values.Value;
import org.neo4j.bolt.connection.values.ValueFactory;

public class RouteMessageResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Map<String, Value>> completableFuture;
    private final ValueFactory valueFactory;

    public RouteMessageResponseHandler(CompletableFuture<Map<String, Value>> completableFuture, ValueFactory valueFactory) {
        this.completableFuture = Objects.requireNonNull(completableFuture);
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        try {
            this.completableFuture.complete(metadata.get("rt").asMap(arg_0 -> ((ValueFactory)this.valueFactory).value(arg_0)));
        }
        catch (Exception ex) {
            this.completableFuture.completeExceptionally(ex);
        }
    }

    @Override
    public void onFailure(Throwable error) {
        this.completableFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        this.completableFuture.completeExceptionally(new UnsupportedOperationException("Route is not expected to receive records: " + Arrays.toString(fields)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteMessageResponseHandler that = (RouteMessageResponseHandler)o;
        return this.completableFuture.equals(that.completableFuture);
    }

    public int hashCode() {
        return Objects.hash(this.completableFuture);
    }
}

