/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.inbound;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CodecException;
import java.io.IOException;
import java.util.Objects;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.exception.BoltConnectionReadTimeoutException;
import org.neo4j.bolt.connection.exception.BoltServiceUnavailableException;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.bolt.connection.netty.impl.async.inbound.InboundMessageDispatcher;
import org.neo4j.bolt.connection.netty.impl.logging.ChannelActivityLogger;
import org.neo4j.bolt.connection.netty.impl.logging.ChannelErrorLogger;

public class ChannelErrorHandler
extends ChannelInboundHandlerAdapter {
    private final LoggingProvider logging;
    private InboundMessageDispatcher messageDispatcher;
    private ChannelActivityLogger log;
    private ChannelErrorLogger errorLog;
    private boolean failed;

    public ChannelErrorHandler(LoggingProvider logging) {
        this.logging = logging;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.messageDispatcher = Objects.requireNonNull(ChannelAttributes.messageDispatcher(ctx.channel()));
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, ((Object)((Object)this)).getClass());
        this.errorLog = new ChannelErrorLogger(ctx.channel(), this.logging);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.messageDispatcher = null;
        this.log = null;
        this.failed = false;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        BoltServiceUnavailableException error;
        this.log.log(System.Logger.Level.DEBUG, "Channel is inactive");
        String terminationReason = ChannelAttributes.terminationReason(ctx.channel());
        BoltServiceUnavailableException boltServiceUnavailableException = error = terminationReason == null ? new BoltServiceUnavailableException("Connection to the database terminated. Please ensure that your database is listening on the correct host and port and that you have compatible encryption settings both on Neo4j server and driver. Note that the default encryption setting has changed in Neo4j 4.0.") : new BoltServiceUnavailableException("Connection to the database terminated. " + terminationReason);
        if (!this.failed) {
            this.messageDispatcher.handleChannelInactive((Throwable)error);
        } else {
            this.fail((Throwable)error);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        if (this.failed) {
            this.errorLog.traceOrDebug("Another fatal error occurred in the pipeline", error);
        } else {
            this.failed = true;
            this.logUnexpectedErrorWarning(error);
            this.fail(error);
        }
    }

    private void logUnexpectedErrorWarning(Throwable error) {
        if (!(error instanceof BoltConnectionReadTimeoutException)) {
            this.errorLog.traceOrDebug("Fatal error occurred in the pipeline", error);
        }
    }

    private void fail(Throwable error) {
        Throwable cause = ChannelErrorHandler.transformError(error);
        this.messageDispatcher.handleChannelError(cause);
    }

    private static Throwable transformError(Throwable error) {
        if (error instanceof CodecException && error.getCause() != null) {
            error = error.getCause();
        }
        if (error instanceof IOException) {
            return new BoltServiceUnavailableException("Connection to the database failed", error);
        }
        return error;
    }
}

