/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.bolt.connection.netty.impl.async.connection.ChannelPipelineBuilder;
import org.neo4j.bolt.connection.netty.impl.async.inbound.ChannelErrorHandler;
import org.neo4j.bolt.connection.netty.impl.async.inbound.ChunkDecoder;
import org.neo4j.bolt.connection.netty.impl.async.inbound.InboundMessageHandler;
import org.neo4j.bolt.connection.netty.impl.async.inbound.MessageDecoder;
import org.neo4j.bolt.connection.netty.impl.async.outbound.OutboundMessageHandler;
import org.neo4j.bolt.connection.netty.impl.messaging.MessageFormat;
import org.neo4j.bolt.connection.values.ValueFactory;

public class ChannelPipelineBuilderImpl
implements ChannelPipelineBuilder {
    @Override
    public void build(MessageFormat messageFormat, ChannelPipeline pipeline, LoggingProvider logging, ValueFactory valueFactory) {
        pipeline.addLast(new ChannelHandler[]{new ChunkDecoder(logging)});
        pipeline.addLast(new ChannelHandler[]{new MessageDecoder()});
        Channel channel = pipeline.channel();
        InboundMessageHandler inboundMessageHandler = new InboundMessageHandler(messageFormat, logging, valueFactory);
        ChannelAttributes.addBoltPatchesListener(channel, inboundMessageHandler);
        pipeline.addLast(new ChannelHandler[]{inboundMessageHandler});
        OutboundMessageHandler outboundMessageHandler = new OutboundMessageHandler(messageFormat, logging, valueFactory);
        ChannelAttributes.addBoltPatchesListener(channel, outboundMessageHandler);
        pipeline.addLast(OutboundMessageHandler.NAME, (ChannelHandler)outboundMessageHandler);
        pipeline.addLast(new ChannelHandler[]{new ChannelErrorHandler(logging)});
    }
}

