/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class ReluInitScheme
extends BaseWeightInitScheme {
    private double fanIn;

    public ReluInitScheme(char order, double fanIn) {
        super(order);
        this.fanIn = fanIn;
    }

    @Override
    public INDArray doCreate(long[] shape, INDArray paramsView) {
        return Nd4j.randn(this.order(), shape).muli(FastMath.sqrt((double)(2.0 / this.fanIn)));
    }

    @Override
    public WeightInit type() {
        return WeightInit.RELU;
    }

    public static ReluInitSchemeBuilder builder() {
        return new ReluInitSchemeBuilder();
    }

    public static class ReluInitSchemeBuilder {
        private char order;
        private double fanIn;

        ReluInitSchemeBuilder() {
        }

        public ReluInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public ReluInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public ReluInitScheme build() {
            return new ReluInitScheme(this.order, this.fanIn);
        }

        public String toString() {
            return "ReluInitScheme.ReluInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ")";
        }
    }
}

