/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import java.util.Map;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.NesterovsUpdater;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class Nesterovs
implements IUpdater {
    public static final double DEFAULT_NESTEROV_MOMENTUM = 0.9;
    public static final double DEFAULT_NESTEROV_LEARNING_RATE = 0.1;
    private double learningRate;
    private ISchedule learningRateSchedule;
    private double momentum;
    private ISchedule momentumISchedule;
    @Deprecated
    private Map<Integer, Double> momentumSchedule;

    public Nesterovs() {
        this(0.1, null, 0.9, null);
    }

    public Nesterovs(double momentum) {
        this(0.1, momentum);
    }

    public Nesterovs(double learningRate, double momentum) {
        this(learningRate, null, momentum, null);
    }

    public Nesterovs(ISchedule learningRateSchedule) {
        this(Double.NaN, learningRateSchedule, 0.9, null);
    }

    public Nesterovs(ISchedule learningRateSchedule, double momentum) {
        this(Double.NaN, learningRateSchedule, momentum, null);
    }

    public Nesterovs(ISchedule learningRateSchedule, ISchedule momentumSchedule) {
        this(Double.NaN, learningRateSchedule, Double.NaN, momentumSchedule);
    }

    public Nesterovs(double learningRate, ISchedule momentumSchedule) {
        this(learningRate, null, Double.NaN, momentumSchedule);
    }

    private Nesterovs(@JsonProperty(value="learningRate") double learningRate, @JsonProperty(value="learningRateSchedule") ISchedule learningRateSchedule, @JsonProperty(value="momentum") double momentum, @JsonProperty(value="momentumSchedule") ISchedule momentumISchedule) {
        this.learningRate = learningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.momentum = momentum;
        this.momentumISchedule = momentumISchedule;
    }

    @Override
    public long stateSize(long numParams) {
        return numParams;
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        NesterovsUpdater u = new NesterovsUpdater(this);
        u.setStateViewArray(viewArray, viewArray.shape(), viewArray.ordering(), initializeViewArray);
        return u;
    }

    @Override
    public Nesterovs clone() {
        return new Nesterovs(this.learningRate, this.learningRateSchedule, this.momentum, this.momentumISchedule);
    }

    @Override
    public double getLearningRate(int iteration, int epoch) {
        if (this.learningRateSchedule != null) {
            return this.learningRateSchedule.valueAt(iteration, epoch);
        }
        return this.learningRate;
    }

    @Override
    public boolean hasLearningRate() {
        return true;
    }

    @Override
    public void setLrAndSchedule(double lr, ISchedule lrSchedule) {
        this.learningRate = lr;
        this.learningRateSchedule = lrSchedule;
    }

    public double currentMomentum(int iteration, int epoch) {
        if (this.momentumISchedule != null) {
            return this.momentumISchedule.valueAt(iteration, epoch);
        }
        return this.momentum;
    }

    private static double $default$learningRate() {
        return 0.1;
    }

    private static double $default$momentum() {
        return 0.9;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Nesterovs(double learningRate, ISchedule learningRateSchedule, double momentum, ISchedule momentumISchedule, Map<Integer, Double> momentumSchedule) {
        this.learningRate = learningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.momentum = momentum;
        this.momentumISchedule = momentumISchedule;
        this.momentumSchedule = momentumSchedule;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public ISchedule getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public ISchedule getMomentumISchedule() {
        return this.momentumISchedule;
    }

    @Deprecated
    public Map<Integer, Double> getMomentumSchedule() {
        return this.momentumSchedule;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setLearningRateSchedule(ISchedule learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }

    public void setMomentumISchedule(ISchedule momentumISchedule) {
        this.momentumISchedule = momentumISchedule;
    }

    @Deprecated
    public void setMomentumSchedule(Map<Integer, Double> momentumSchedule) {
        this.momentumSchedule = momentumSchedule;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Nesterovs)) {
            return false;
        }
        Nesterovs other = (Nesterovs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        ISchedule this$learningRateSchedule = this.getLearningRateSchedule();
        ISchedule other$learningRateSchedule = other.getLearningRateSchedule();
        if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !this$learningRateSchedule.equals(other$learningRateSchedule)) {
            return false;
        }
        if (Double.compare(this.getMomentum(), other.getMomentum()) != 0) {
            return false;
        }
        ISchedule this$momentumISchedule = this.getMomentumISchedule();
        ISchedule other$momentumISchedule = other.getMomentumISchedule();
        if (this$momentumISchedule == null ? other$momentumISchedule != null : !this$momentumISchedule.equals(other$momentumISchedule)) {
            return false;
        }
        Map<Integer, Double> this$momentumSchedule = this.getMomentumSchedule();
        Map<Integer, Double> other$momentumSchedule = other.getMomentumSchedule();
        return !(this$momentumSchedule == null ? other$momentumSchedule != null : !((Object)this$momentumSchedule).equals(other$momentumSchedule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Nesterovs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        ISchedule $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : $learningRateSchedule.hashCode());
        long $momentum = Double.doubleToLongBits(this.getMomentum());
        result = result * 59 + (int)($momentum >>> 32 ^ $momentum);
        ISchedule $momentumISchedule = this.getMomentumISchedule();
        result = result * 59 + ($momentumISchedule == null ? 43 : $momentumISchedule.hashCode());
        Map<Integer, Double> $momentumSchedule = this.getMomentumSchedule();
        result = result * 59 + ($momentumSchedule == null ? 43 : ((Object)$momentumSchedule).hashCode());
        return result;
    }

    public String toString() {
        return "Nesterovs(learningRate=" + this.getLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", momentum=" + this.getMomentum() + ", momentumISchedule=" + this.getMomentumISchedule() + ", momentumSchedule=" + this.getMomentumSchedule() + ")";
    }

    public static class Builder {
        private boolean learningRate$set;
        private double learningRate;
        private ISchedule learningRateSchedule;
        private boolean momentum$set;
        private double momentum;
        private ISchedule momentumISchedule;
        private Map<Integer, Double> momentumSchedule;

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            this.learningRate$set = true;
            return this;
        }

        public Builder learningRateSchedule(ISchedule learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return this;
        }

        public Builder momentum(double momentum) {
            this.momentum = momentum;
            this.momentum$set = true;
            return this;
        }

        public Builder momentumISchedule(ISchedule momentumISchedule) {
            this.momentumISchedule = momentumISchedule;
            return this;
        }

        @Deprecated
        public Builder momentumSchedule(Map<Integer, Double> momentumSchedule) {
            this.momentumSchedule = momentumSchedule;
            return this;
        }

        public Nesterovs build() {
            double learningRate = this.learningRate;
            if (!this.learningRate$set) {
                learningRate = Nesterovs.$default$learningRate();
            }
            double momentum = this.momentum;
            if (!this.momentum$set) {
                momentum = Nesterovs.$default$momentum();
            }
            return new Nesterovs(learningRate, this.learningRateSchedule, momentum, this.momentumISchedule, this.momentumSchedule);
        }

        public String toString() {
            return "Nesterovs.Builder(learningRate=" + this.learningRate + ", learningRateSchedule=" + this.learningRateSchedule + ", momentum=" + this.momentum + ", momentumISchedule=" + this.momentumISchedule + ", momentumSchedule=" + this.momentumSchedule + ")";
        }
    }
}

