/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.RandomOp;
import org.nd4j.linalg.api.shape.Shape;

public abstract class BaseRandomOp
extends BaseOp
implements RandomOp {
    protected long[] shape;

    public BaseRandomOp(SameDiff sameDiff, SDVariable i_v) {
        Preconditions.checkNotNull((Object)i_v, (String)"Input variable can't be null with this constructor");
        this.sameDiff = sameDiff;
        this.xVertexId = i_v.getVarName();
        sameDiff.addArgsFor(new String[]{this.xVertexId}, (DifferentialFunction)this);
        if (Shape.isPlaceholderShape(i_v.getShape())) {
            sameDiff.addPropertyToResolve(this, i_v.getVarName());
        }
    }

    public BaseRandomOp(SameDiff sd, long[] shape) {
        super(sd, (Object[])null);
        Preconditions.checkArgument((shape != null && shape.length > 0 ? 1 : 0) != 0, (String)"Shape must be non-null, length > 0. Got: %s", (Object)shape);
        this.sameDiff = sd;
        this.shape = shape;
        this.setInstanceId();
        this.sameDiff.addArgsFor(new String[0], (DifferentialFunction)this);
    }

    @Override
    public Op.Type opType() {
        return Op.Type.RANDOM;
    }

    @Override
    public List<long[]> calculateOutputShape() {
        if (this.shape != null) {
            return Collections.singletonList(this.shape);
        }
        ArrayList<long[]> ret = new ArrayList<long[]>(1);
        long[] shape = this.sameDiff.getShapeForVarName(this.args()[0].getVarName());
        if (shape != null) {
            ret.add(shape);
        }
        return ret;
    }

    public BaseRandomOp() {
    }
}

