/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upsampling2d
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Upsampling2d.class);
    protected boolean nchw;
    protected int scaleH;
    protected int scaleW;

    public Upsampling2d(SameDiff sameDiff, SDVariable input, boolean nchw, int scaleH, int scaleW) {
        super(null, sameDiff, new SDVariable[]{input});
        this.nchw = nchw;
        this.scaleH = scaleH;
        this.scaleW = scaleW;
        this.addIArgument(scaleH);
        this.addIArgument(scaleW);
        this.addIArgument(nchw ? 1 : 0);
    }

    public Upsampling2d() {
    }

    @Override
    public String opName() {
        return "upsampling2d";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.singletonList(this.f().upsampling2dBp(this.arg(), f1.get(0), this.nchw, this.scaleH, this.scaleW));
    }

    public boolean isNchw() {
        return this.nchw;
    }

    public int getScaleH() {
        return this.scaleH;
    }

    public int getScaleW() {
        return this.scaleW;
    }
}

