/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.convolution.BatchNorm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchNormDerivative
extends BatchNorm {
    private static final Logger log = LoggerFactory.getLogger(BatchNormDerivative.class);

    public BatchNormDerivative(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputArrays, boolean inPlace, boolean applyGamma, boolean applyBeta, double epsilon) {
        super(sameDiff, inputFunctions, inputArrays, outputArrays, inPlace, applyGamma, applyBeta, epsilon);
    }

    public BatchNormDerivative() {
    }

    @Override
    public String opName() {
        return "batchnorm_bp";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Unable to take derivative of derivative.");
    }

    public static BatchNormDerivativeBuilder derivativeBuilder() {
        return new BatchNormDerivativeBuilder();
    }

    public static class BatchNormDerivativeBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputArrays;
        private boolean inPlace;
        private boolean applyGamma;
        private boolean applyBeta;
        private double epsilon;

        BatchNormDerivativeBuilder() {
        }

        public BatchNormDerivativeBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public BatchNormDerivativeBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public BatchNormDerivativeBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public BatchNormDerivativeBuilder outputArrays(INDArray[] outputArrays) {
            this.outputArrays = outputArrays;
            return this;
        }

        public BatchNormDerivativeBuilder inPlace(boolean inPlace) {
            this.inPlace = inPlace;
            return this;
        }

        public BatchNormDerivativeBuilder applyGamma(boolean applyGamma) {
            this.applyGamma = applyGamma;
            return this;
        }

        public BatchNormDerivativeBuilder applyBeta(boolean applyBeta) {
            this.applyBeta = applyBeta;
            return this;
        }

        public BatchNormDerivativeBuilder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public BatchNormDerivative build() {
            return new BatchNormDerivative(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputArrays, this.inPlace, this.applyGamma, this.applyBeta, this.epsilon);
        }

        public String toString() {
            return "BatchNormDerivative.BatchNormDerivativeBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputArrays=" + Arrays.deepToString(this.outputArrays) + ", inPlace=" + this.inPlace + ", applyGamma=" + this.applyGamma + ", applyBeta=" + this.applyBeta + ", epsilon=" + this.epsilon + ")";
        }
    }
}

