/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.onnx.OnnxGraphMapper;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.BatchNormDerivative;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class BatchNorm
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(BatchNorm.class);
    private boolean applyGamma;
    private boolean applyBeta;
    private double epsilon;

    public BatchNorm(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputArrays, boolean inPlace, boolean applyGamma, boolean applyBeta, double epsilon) {
        super(null, sameDiff, inputFunctions, inPlace);
        this.sameDiff = sameDiff;
        this.applyGamma = applyGamma;
        this.applyBeta = applyBeta;
        this.epsilon = epsilon;
        if (inputArrays != null) {
            this.addInputArgument(inputArrays);
        }
        if (outputArrays != null) {
            this.addOutputArgument(outputArrays);
        }
        this.addArgs();
    }

    public void addArgs() {
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.applyGamma));
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.applyBeta));
        this.addTArgument(this.epsilon);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("applyGamma", this.applyGamma);
        ret.put("applyBeta", this.applyBeta);
        ret.put("epsilon", this.epsilon);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap map = new HashMap();
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        OnnxGraphMapper.getInstance().initFunctionFromProperties(node.getOpType(), this, attributesForNode, node, graph);
        this.addArgs();
    }

    @Override
    public String opName() {
        return "batchnorm";
    }

    @Override
    public String onnxName() {
        return "BatchNormalization";
    }

    @Override
    public String tensorflowName() {
        return "FusedBatchNorm";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        BatchNormDerivative batchNormDerivative = BatchNormDerivative.derivativeBuilder().applyGamma(this.applyGamma).applyBeta(this.applyBeta).epsilon(this.epsilon).build();
        ret.addAll(Arrays.asList(batchNormDerivative.outputVariables()));
        return ret;
    }

    public static BatchNormBuilder builder() {
        return new BatchNormBuilder();
    }

    public boolean isApplyGamma() {
        return this.applyGamma;
    }

    public boolean isApplyBeta() {
        return this.applyBeta;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public BatchNorm() {
    }

    public static class BatchNormBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputArrays;
        private boolean inPlace;
        private boolean applyGamma;
        private boolean applyBeta;
        private double epsilon;

        BatchNormBuilder() {
        }

        public BatchNormBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public BatchNormBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public BatchNormBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public BatchNormBuilder outputArrays(INDArray[] outputArrays) {
            this.outputArrays = outputArrays;
            return this;
        }

        public BatchNormBuilder inPlace(boolean inPlace) {
            this.inPlace = inPlace;
            return this;
        }

        public BatchNormBuilder applyGamma(boolean applyGamma) {
            this.applyGamma = applyGamma;
            return this;
        }

        public BatchNormBuilder applyBeta(boolean applyBeta) {
            this.applyBeta = applyBeta;
            return this;
        }

        public BatchNormBuilder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public BatchNorm build() {
            return new BatchNorm(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputArrays, this.inPlace, this.applyGamma, this.applyBeta, this.epsilon);
        }

        public String toString() {
            return "BatchNorm.BatchNormBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputArrays=" + Arrays.deepToString(this.outputArrays) + ", inPlace=" + this.inPlace + ", applyGamma=" + this.applyGamma + ", applyBeta=" + this.applyBeta + ", epsilon=" + this.epsilon + ")";
        }
    }
}

