/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum.distances;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.Shape;

public class EuclideanDistance
extends BaseAccumulation {
    public static final String OP_NAME = "euclidean";

    public EuclideanDistance(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public EuclideanDistance(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public EuclideanDistance() {
    }

    public EuclideanDistance(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public EuclideanDistance(INDArray x, INDArray y, long n) {
        super(x, y, n);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public EuclideanDistance(INDArray x) {
        super(x);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public EuclideanDistance(INDArray x, INDArray y) {
        super(x, y);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    public EuclideanDistance(INDArray x, INDArray y, boolean allDistances) {
        this(x, y);
        this.isComplex = allDistances;
    }

    public EuclideanDistance(INDArray x, INDArray y, INDArray z, boolean allDistances) {
        this(x, y, z, x.lengthLong());
        this.isComplex = allDistances;
    }

    public EuclideanDistance(INDArray x, INDArray y, INDArray z, boolean newFormat, boolean keepDims, int ... dimensions) {
        super(x, y, z, newFormat, keepDims, dimensions);
        this.extraArgs = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f)};
    }

    @Override
    public Op.Type opType() {
        return Op.Type.REDUCE3;
    }

    @Override
    public Op.Type getOpType() {
        return this.opType();
    }

    @Override
    public int opNum() {
        return 1;
    }

    @Override
    public String opName() {
        return OP_NAME;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        SDVariable euc = this.outputVariables()[0];
        SDVariable difference = this.larg().sub(this.rarg());
        int origRank = Shape.rankFromShape(this.arg().getShape());
        SDVariable divBroadcastable = this.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, i_v1.get(0).div(euc));
        SDVariable gradX = difference.mul(divBroadcastable);
        SDVariable gradY = this.f().neg(gradX);
        return Arrays.asList(gradX, gradY);
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }
}

