/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.flatbuffers.FlatBufferBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Generator;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.BaseSparseNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.SparseFormat;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndexAll;
import org.nd4j.linalg.indexing.NewAxis;
import org.nd4j.linalg.indexing.PointIndex;
import org.nd4j.linalg.indexing.ShapeOffsetResolution;
import org.nd4j.linalg.indexing.SpecifiedIndex;
import org.nd4j.linalg.profiler.OpProfiler;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.LongUtils;

public class BaseSparseNDArrayCOO
extends BaseSparseNDArray {
    protected static final SparseFormat format = SparseFormat.COO;
    protected volatile transient DataBuffer values;
    protected volatile transient DataBuffer indices;
    protected volatile transient boolean isSorted = false;

    public BaseSparseNDArrayCOO(DataBuffer values, DataBuffer indices, long[] shape) {
        Preconditions.checkArgument((values.length() * (long)shape.length == indices.length() ? 1 : 0) != 0);
        this.values = values;
        this.indices = indices;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape));
        this.init(shape);
        this.length = values.length();
        int[] flags = new int[this.rank()];
        long[] sparseOffsets = new long[this.rank()];
        int[] hiddenDimension = new int[]{-1};
        this.sparseInformation = Nd4j.getSparseInfoProvider().createSparseInformation(flags, sparseOffsets, hiddenDimension, this.rank());
    }

    public BaseSparseNDArrayCOO(double[] values, long[][] indices, long[] shape) {
        this.indices = BaseSparseNDArrayCOO.createIndiceBuffer(indices, shape);
        this.values = BaseSparseNDArrayCOO.createValueBuffer(values);
        this.length = values.length;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape));
        this.init(shape);
        this.sparseInformation = BaseSparseNDArrayCOO.createSparseInformationBuffer(this.rank());
        this.checkBufferCoherence();
    }

    public BaseSparseNDArrayCOO(float[] values, long[][] indices, long[] shape) {
        this.indices = BaseSparseNDArrayCOO.createIndiceBuffer(indices, shape);
        this.values = BaseSparseNDArrayCOO.createValueBuffer(values);
        this.length = values.length;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape));
        this.init(shape);
        this.sparseInformation = BaseSparseNDArrayCOO.createSparseInformationBuffer(this.rank());
        this.checkBufferCoherence();
    }

    public BaseSparseNDArrayCOO(double[] values, int[][] indices, long[] shape) {
        this.indices = BaseSparseNDArrayCOO.createIndiceBuffer(indices, shape);
        this.values = BaseSparseNDArrayCOO.createValueBuffer(values);
        this.length = values.length;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape));
        this.init(shape);
        this.sparseInformation = BaseSparseNDArrayCOO.createSparseInformationBuffer(this.rank());
        this.checkBufferCoherence();
    }

    public BaseSparseNDArrayCOO(float[] values, int[][] indices, long[] shape) {
        this.indices = BaseSparseNDArrayCOO.createIndiceBuffer(indices, shape);
        this.values = BaseSparseNDArrayCOO.createValueBuffer(values);
        this.length = values.length;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape));
        this.init(shape);
        this.sparseInformation = BaseSparseNDArrayCOO.createSparseInformationBuffer(this.rank());
        this.checkBufferCoherence();
    }

    public BaseSparseNDArrayCOO(DataBuffer values, DataBuffer indices, DataBuffer sparseInformation, long[] shape) {
        this.values = Nd4j.createBuffer(values, 0L, values.length());
        this.indices = indices;
        this.setShapeInformation(Nd4j.getShapeInfoProvider().createShapeInformation(shape));
        this.init(shape);
        this.sparseInformation = sparseInformation;
        this.length = this.countNNZ();
    }

    public BaseSparseNDArrayCOO(DataBuffer values, DataBuffer indices, long[] sparseOffsets, int[] flags, int[] hiddenDimensions, int underlyingRank, long[] shape) {
        this(values, indices, Nd4j.getSparseInfoProvider().createSparseInformation(flags, sparseOffsets, hiddenDimensions, underlyingRank), shape);
    }

    protected void checkBufferCoherence() {
        if (this.values.length() < this.length) {
            throw new IllegalStateException("nnz is larger than capacity of buffers");
        }
        if (this.values.length() * (long)this.rank() != this.indices.length()) {
            throw new IllegalArgumentException("Sizes of values, indices and shape are incoherent.");
        }
    }

    protected static DataBuffer createSparseInformationBuffer(int rank) {
        int[] flags = new int[rank];
        long[] sparseOffsets = new long[rank];
        int[] hiddenDimension = new int[]{-1};
        return Nd4j.getSparseInfoProvider().createSparseInformation(flags, sparseOffsets, hiddenDimension, rank);
    }

    protected static DataBuffer createValueBuffer(float[] values) {
        Preconditions.checkNotNull((Object)values);
        if (values.length == 0) {
            return Nd4j.createBuffer(1L);
        }
        return Nd4j.createBuffer(values);
    }

    protected static DataBuffer createValueBuffer(double[] values) {
        Preconditions.checkNotNull((Object)values);
        if (values.length == 0) {
            return Nd4j.createBuffer(1L);
        }
        return Nd4j.createBuffer(values);
    }

    protected static DataBuffer createIndiceBuffer(long[][] indices, long[] shape) {
        Preconditions.checkNotNull((Object)indices);
        Preconditions.checkNotNull((Object)shape);
        if (indices.length == 0) {
            return Nd4j.getDataBufferFactory().createLong((long)shape.length);
        }
        if (indices.length == shape.length) {
            return Nd4j.createBuffer(ArrayUtil.flattenF((long[][])indices));
        }
        return Nd4j.createBuffer(ArrayUtil.flatten((long[][])indices));
    }

    protected static DataBuffer createIndiceBuffer(int[][] indices, long[] shape) {
        Preconditions.checkNotNull((Object)indices);
        Preconditions.checkNotNull((Object)shape);
        if (indices.length == 0) {
            return Nd4j.getDataBufferFactory().createLong((long)shape.length);
        }
        if (indices.length == shape.length) {
            return Nd4j.createBuffer(ArrayUtil.toLongArray((int[])ArrayUtil.flattenF((int[][])indices)));
        }
        return Nd4j.createBuffer(ArrayUtil.toLongArray((int[])ArrayUtil.flatten((int[][])indices)));
    }

    @Override
    public int toFlatArray(FlatBufferBuilder builder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray convertToHalfs() {
        return null;
    }

    public long countNNZ() {
        long count = 0L;
        int i = 0;
        while ((long)i < this.values.length()) {
            int[] idx = this.getUnderlyingIndicesOf(i).asInt();
            boolean isIn = true;
            int idxNotFixed = 0;
            for (int dim = 0; dim < idx.length; ++dim) {
                if (this.flags()[dim] == 1) {
                    if (this.sparseOffsets()[dim] == idx[dim]) continue;
                    isIn = false;
                    break;
                }
                int lowerBound = this.sparseOffsets()[dim];
                long upperBound = (long)this.sparseOffsets()[dim] + this.shape()[idxNotFixed];
                if (idx[dim] < lowerBound || (long)idx[dim] >= upperBound) {
                    isIn = false;
                    break;
                }
                ++idxNotFixed;
            }
            count = isIn ? count + 1L : count;
            ++i;
        }
        return count;
    }

    @Override
    public INDArray assign(INDArray arr) {
        this.sort();
        return this;
    }

    public void sort() {
        if (!this.isSorted) {
            Nd4j.sparseFactory().sortCooIndices(this);
            this.isSorted = true;
        }
    }

    public long[] translateToPhysical(long[] virtualIndexes) {
        long[] physicalIndexes = new long[this.underlyingRank()];
        int idxPhy = 0;
        int hidden = 0;
        for (int idxVir = 0; idxVir < virtualIndexes.length; ++idxVir) {
            if (hidden < this.getNumHiddenDimension() && this.hiddenDimensions()[hidden] == idxVir) {
                ++hidden;
                continue;
            }
            while (idxPhy < this.underlyingRank() && this.isDimensionFixed(idxPhy)) {
                physicalIndexes[idxPhy] = this.sparseOffsets()[idxPhy];
                ++idxPhy;
            }
            if (idxPhy >= this.underlyingRank() || this.isDimensionFixed(idxPhy)) continue;
            physicalIndexes[idxPhy] = (long)this.sparseOffsets()[idxPhy] + virtualIndexes[idxVir];
            ++idxPhy;
        }
        return physicalIndexes;
    }

    public int[] translateToPhysical(int[] virtualIndexes) {
        int[] physicalIndexes = new int[this.underlyingRank()];
        int idxPhy = 0;
        int hidden = 0;
        for (int idxVir = 0; idxVir < virtualIndexes.length; ++idxVir) {
            if (hidden < this.getNumHiddenDimension() && this.hiddenDimensions()[hidden] == idxVir) {
                ++hidden;
                continue;
            }
            while (idxPhy < this.underlyingRank() && this.isDimensionFixed(idxPhy)) {
                physicalIndexes[idxPhy] = this.sparseOffsets()[idxPhy];
                ++idxPhy;
            }
            if (idxPhy >= this.underlyingRank() || this.isDimensionFixed(idxPhy)) continue;
            physicalIndexes[idxPhy] = this.sparseOffsets()[idxPhy] + virtualIndexes[idxVir];
            ++idxPhy;
        }
        return physicalIndexes;
    }

    public boolean isDimensionFixed(int i) {
        return this.flags()[i] == 1;
    }

    @Override
    public INDArray putScalar(long i, double value) {
        if (i < 0L) {
            i += (long)this.rank();
        }
        if (this.isScalar()) {
            if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.DISABLED && Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.SCOPE_PANIC) {
                OpProfiler.getInstance().processScalarCall();
            }
            this.addOrUpdate(new long[]{0L, 0L}, value);
            return this;
        }
        if (this.isRowVector()) {
            this.addOrUpdate(new long[]{0L, i}, value);
            return this;
        }
        if (this.isColumnVector()) {
            this.addOrUpdate(new long[]{i, 0L}, value);
            return this;
        }
        long[] indexes = this.ordering() == 'c' ? Shape.ind2subC(this, i) : Shape.ind2sub(this, i);
        return this.putScalar(indexes, value);
    }

    @Override
    public INDArray putScalar(long i, float value) {
        return this.putScalar(i, (double)value);
    }

    @Override
    public INDArray putScalar(long i, int value) {
        return this.putScalar(i, (double)value);
    }

    @Override
    public INDArray putScalar(int[] indexes, double value) {
        return this.putScalar(ArrayUtil.toLongArray((int[])indexes), value);
    }

    @Override
    public INDArray putScalar(long[] indexes, double value) {
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= 0L) continue;
            int n = i;
            indexes[n] = indexes[n] + (long)this.rank();
        }
        if (indexes.length == 1) {
            return this.putScalar(indexes[0], value);
        }
        if (indexes.length != this.rank) {
            throw new IllegalStateException("Cannot use putScalar with indexes length " + indexes.length + " on rank " + this.rank);
        }
        this.addOrUpdate(indexes, value);
        return this;
    }

    @Override
    public INDArray putScalar(long[] i, float value) {
        return null;
    }

    @Override
    public INDArray putScalar(long[] i, int value) {
        return null;
    }

    @Override
    public INDArray putScalar(long row, long col, double value) {
        return this.putScalar(new long[]{row, col}, value);
    }

    @Override
    public INDArray putScalar(long dim0, long dim1, long dim2, double value) {
        return this.putScalar(new long[]{dim0, dim1, dim2}, value);
    }

    @Override
    public INDArray putScalar(long dim0, long dim1, long dim2, long dim3, double value) {
        return this.putScalar(new long[]{dim0, dim1, dim2, dim3}, value);
    }

    @Override
    public INDArray putRow(long row, INDArray toPut) {
        if (this.isRowVector() && toPut.isVector()) {
            return this.assign(toPut);
        }
        return this.put(new INDArrayIndex[]{NDArrayIndex.point(row), NDArrayIndex.all()}, toPut);
    }

    @Override
    public INDArray putColumn(int column, INDArray toPut) {
        if (this.isColumnVector() && toPut.isVector()) {
            return this.assign(toPut);
        }
        return this.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.point(column)}, toPut);
    }

    @Override
    public INDArray put(INDArrayIndex[] indices, INDArray element) {
        if (indices[0] instanceof SpecifiedIndex && element.isVector()) {
            indices[0].reset();
            int cnt = 0;
            while (indices[0].hasNext()) {
                long idx = indices[0].next();
                this.putScalar((long)((int)idx), element.getDouble((long)cnt));
                ++cnt;
            }
            return this;
        }
        return this.get(indices).assign(element);
    }

    @Override
    public INDArray put(INDArrayIndex[] indices, Number element) {
        INDArray get = this.get(indices);
        int i = 0;
        while ((long)i < get.length()) {
            get.putScalar((long)i, element.doubleValue());
            ++i;
        }
        return this;
    }

    @Override
    public INDArray put(int[] indexes, INDArray element) {
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Unable to insert anything but a scalar");
        }
        if (indexes.length != this.rank) {
            throw new IllegalStateException("Cannot use putScalar with indexes length " + indexes.length + " on rank " + this.rank);
        }
        this.addOrUpdate(ArrayUtil.toLongArray((int[])indexes), element.getDouble(0L));
        return this;
    }

    @Override
    public INDArray put(int i, int j, INDArray element) {
        return this.put(new int[]{i, j}, element);
    }

    @Override
    public INDArray put(int i, int j, Number element) {
        return this.putScalar(new int[]{i, j}, element.doubleValue());
    }

    @Override
    public INDArray put(int i, INDArray element) {
        if (!element.isScalar()) {
            throw new IllegalArgumentException("Element must be a scalar");
        }
        return this.putScalar((long)i, element.getDouble(0L));
    }

    public void addOrUpdate(long[] indexes, double value) {
        long[] physicalIndexes = this.isView() ? this.translateToPhysical(indexes) : indexes;
        int i = 0;
        while ((long)i < this.length) {
            long[] idx = this.getUnderlyingIndicesOf(i).asLong();
            if (Arrays.equals(idx, physicalIndexes)) {
                if (value == 0.0) {
                    this.removeEntry(i);
                    --this.length;
                } else {
                    this.values.put((long)i, value);
                    ++this.length;
                }
                return;
            }
            ++i;
        }
        if (value == 0.0) {
            return;
        }
        while (!this.canInsert(this.values, 1)) {
            long size = (long)Math.ceil((double)this.values.capacity() * 2.0);
            this.values.reallocate(size);
        }
        this.values.put(this.length, value);
        while (!this.canInsert(this.indices, physicalIndexes.length)) {
            long size = (long)Math.ceil((double)this.indices.capacity() * 2.0);
            this.indices.reallocate(size);
        }
        for (i = 0; i < physicalIndexes.length; ++i) {
            this.indices.put(this.length * (long)this.rank() + (long)i, physicalIndexes[i]);
        }
        ++this.length;
        this.isSorted = false;
    }

    public boolean canInsert(DataBuffer buffer, int length) {
        return buffer.capacity() - buffer.length() >= (long)length;
    }

    public DataBuffer shiftLeft(DataBuffer buffer, int from, int offset, long datalength) {
        int i = from;
        while ((long)i < datalength) {
            buffer.put((long)(i - offset), buffer.getDouble((long)i));
            ++i;
        }
        return buffer;
    }

    public INDArray removeEntry(int idx) {
        this.values = this.shiftLeft(this.values, idx + 1, 1, this.length());
        this.indices = this.shiftLeft(this.indices, (int)((long)idx * this.shape.length() + this.shape.length()), (int)this.shape.length(), this.indices.length());
        return this;
    }

    @Override
    public INDArray get(INDArrayIndex ... indexes) {
        this.sort();
        if (indexes.length == 1 && indexes[0] instanceof NDArrayIndexAll || indexes.length == 2 && (this.isRowVector() && indexes[0] instanceof PointIndex && indexes[0].offset() == 0L && indexes[1] instanceof NDArrayIndexAll || this.isColumnVector() && indexes[1] instanceof PointIndex && indexes[0].offset() == 0L && indexes[0] instanceof NDArrayIndexAll)) {
            return this;
        }
        indexes = NDArrayIndex.resolve(this.shapeInfoDataBuffer(), indexes);
        ShapeOffsetResolution resolution = new ShapeOffsetResolution(this);
        resolution.exec(indexes);
        if (indexes.length < 1) {
            throw new IllegalStateException("Invalid index found of zero length");
        }
        long[] shape = resolution.getShapes();
        int numSpecifiedIndex = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (!(indexes[i] instanceof SpecifiedIndex)) continue;
            ++numSpecifiedIndex;
        }
        if (shape != null && numSpecifiedIndex > 0) {
            Generator<List<List<Long>>> gen = SpecifiedIndex.iterateOverSparse(indexes);
            INDArray ret = Nd4j.createSparseCOO(new double[0], (int[][])new int[0][], shape);
            int maxValue = ArrayUtil.prod((long[])this.shape());
            for (int count = 0; count < maxValue; ++count) {
                try {
                    List next = (List)gen.next();
                    ArrayList<Integer> coordsCombo = new ArrayList<Integer>();
                    ArrayList<Integer> cooIdx = new ArrayList<Integer>();
                    for (int i = 0; i < next.size(); ++i) {
                        if (((List)next.get(i)).size() != 2) {
                            throw new IllegalStateException("Illegal entry returned");
                        }
                        coordsCombo.add(((Long)((List)next.get(i)).get(0)).intValue());
                        cooIdx.add(((Long)((List)next.get(i)).get(1)).intValue());
                    }
                    int[] idx = Ints.toArray(coordsCombo);
                    if (this.isZero(idx)) continue;
                    double val = this.getDouble(idx);
                    ret.putScalar(this.filterOutFixedDimensions(resolution.getFixed(), cooIdx), val);
                    continue;
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                    break;
                }
            }
            return ret;
        }
        int numNewAxis = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (!(indexes[i] instanceof NewAxis)) continue;
            ++numNewAxis;
        }
        if (numNewAxis != 0) {
            // empty if block
        }
        INDArray ret = this.subArray(resolution);
        return ret;
    }

    @Override
    public INDArray repeat(int dimension, long ... repeats) {
        return null;
    }

    public int[] filterOutFixedDimensions(int[] flags, List<Integer> idx) {
        int lastIdx;
        Preconditions.checkArgument((flags.length == idx.size() ? 1 : 0) != 0);
        for (int i = lastIdx = idx.size() - 1; i >= 0; --i) {
            if (flags[i] != 1) continue;
            idx.remove(i);
        }
        return Ints.toArray(idx);
    }

    public int reverseIndexes(int ... indexes) {
        long[] idx = this.translateToPhysical(ArrayUtil.toLongArray((int[])indexes));
        this.sort();
        return this.indexesBinarySearch(0, (int)this.length(), ArrayUtil.toInts((long[])idx));
    }

    public int indexesBinarySearch(int lowerBound, int upperBound, int[] idx) {
        int max = upperBound;
        int min = lowerBound;
        int mid = (max + min) / 2;
        int[] midIdx = this.getUnderlyingIndicesOf(mid).asInt();
        if (Arrays.equals(idx, midIdx)) {
            return mid;
        }
        if (ArrayUtil.lessThan((int[])idx, (int[])midIdx)) {
            max = mid;
        }
        if (ArrayUtil.greaterThan((int[])idx, (int[])midIdx)) {
            min = mid;
        }
        if (min == max) {
            return -1;
        }
        return this.indexesBinarySearch(min, max, idx);
    }

    @Override
    public INDArray getScalar(int ... indices) {
        return super.getScalar(indices);
    }

    @Override
    public INDArray getScalar(long ... indices) {
        return null;
    }

    @Override
    public int getInt(int ... indices) {
        return super.getInt(indices);
    }

    @Override
    public double getDouble(int ... indices) {
        int valIdx = this.reverseIndexes(indices);
        if (valIdx == -1) {
            return 0.0;
        }
        return this.values.getDouble((long)valIdx);
    }

    @Override
    public double getDouble(long ... indices) {
        return 0.0;
    }

    @Override
    public float getFloat(int[] indices) {
        return (float)this.getDouble(indices);
    }

    @Override
    public float getFloat(long[] indices) {
        return 0.0f;
    }

    @Override
    public double getDouble(long i) {
        if (i >= this.length()) {
            throw new IllegalArgumentException("Unable to get linear index >= " + this.length());
        }
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.DISABLED && Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.SCOPE_PANIC) {
            OpProfiler.getInstance().processScalarCall();
        }
        if (i == 0L) {
            return this.data().getDouble(i);
        }
        long[] dimensions = this.ordering() == 'c' ? Shape.ind2subC(this, i) : Shape.ind2sub(this, i);
        Shape.assertShapeLessThan(dimensions, this.shape());
        return this.getDouble(dimensions);
    }

    @Override
    public double getDouble(long i, long j) {
        return this.getDouble(new long[]{i, j});
    }

    @Override
    public float getFloat(long i) {
        return (float)this.getDouble(i);
    }

    @Override
    public float getFloat(long i, long j) {
        return (float)this.getDouble(i, j);
    }

    @Override
    public INDArray reshape(char order, int ... newShape) {
        return null;
    }

    @Override
    public INDArray reshape(int[] shape) {
        return null;
    }

    @Override
    public SparseFormat getFormat() {
        return format;
    }

    @Override
    public int underlyingRank() {
        return Shape.underlyingRank(this.sparseInformation);
    }

    @Override
    public DataBuffer data() {
        return this.values;
    }

    public DataBuffer getUnderlyingIndices() {
        return this.indices;
    }

    public DataBuffer getIncludedIndices() {
        if (this.isScalar()) {
            return Nd4j.createBuffer(new int[]{0, 0});
        }
        ArrayList<Integer> ind = new ArrayList<Integer>();
        int i = 0;
        while ((long)i < this.values.length()) {
            boolean isIn = true;
            int idxNotFixed = 0;
            int[] idx = this.getUnderlyingIndicesOf(i).asInt();
            for (int dim = 0; dim < idx.length; ++dim) {
                if (this.flags()[dim] == 1) {
                    if (this.sparseOffsets()[dim] == idx[dim]) continue;
                    isIn = false;
                    break;
                }
                int lowerBound = this.sparseOffsets()[dim];
                long upperBound = (long)this.sparseOffsets()[dim] + this.shape()[idxNotFixed];
                if (idx[dim] < lowerBound || (long)idx[dim] >= upperBound) {
                    isIn = false;
                    break;
                }
                ++idxNotFixed;
            }
            if (isIn) {
                int notFixedDim = 0;
                for (int dim = 0; dim < idx.length; ++dim) {
                    if (this.flags()[dim] != 0) continue;
                    if (this.shape()[notFixedDim] == 1L) {
                        ind.add(0);
                        ++notFixedDim;
                        continue;
                    }
                    ind.add(idx[dim] - this.sparseOffsets()[dim]);
                }
            }
            ++i;
        }
        return Nd4j.createBuffer(Ints.toArray(ind));
    }

    public DataBuffer getUnderlyingValues() {
        return this.values;
    }

    public DataBuffer getIncludedValues() {
        ArrayList<Double> val = new ArrayList<Double>();
        int i = 0;
        while ((long)i < this.values.length()) {
            boolean isIn = true;
            int idxNotFixed = 0;
            int[] idx = this.getUnderlyingIndicesOf(i).asInt();
            for (int dim = 0; dim < idx.length; ++dim) {
                if (this.flags()[dim] == 1) {
                    if (this.sparseOffsets()[dim] == idx[dim]) continue;
                    isIn = false;
                    break;
                }
                int lowerBound = this.sparseOffsets()[dim];
                long upperBound = (long)this.sparseOffsets()[dim] + this.shape()[idxNotFixed];
                if (idx[dim] < lowerBound || (long)idx[dim] >= upperBound) {
                    isIn = false;
                    break;
                }
                ++idxNotFixed;
            }
            if (isIn) {
                val.add(this.values.getDouble((long)i));
            }
            ++i;
        }
        return Nd4j.createBuffer(Doubles.toArray(val));
    }

    @Override
    public DataBuffer getVectorCoordinates() {
        int idx;
        if (this.isRowVector()) {
            idx = 1;
        } else if (this.isColumnVector()) {
            idx = 0;
        } else {
            throw new UnsupportedOperationException();
        }
        int[] temp = new int[(int)this.length()];
        int i = 0;
        while ((long)i < this.length()) {
            temp[i] = this.getUnderlyingIndicesOf(i).getInt((long)idx);
            ++i;
        }
        return Nd4j.createBuffer(temp);
    }

    @Override
    public INDArray toDense() {
        INDArray result = Nd4j.zeros(this.shape());
        switch (this.data().dataType()) {
            case DOUBLE: {
                int i = 0;
                while ((long)i < this.length) {
                    int[] idx = this.getUnderlyingIndicesOf(i).asInt();
                    double value = this.values.getDouble((long)i);
                    result.putScalar(idx, value);
                    ++i;
                }
                break;
            }
            case FLOAT: {
                int i = 0;
                while ((long)i < this.length) {
                    int[] idx = this.getUnderlyingIndicesOf(i).asInt();
                    float value = this.values.getFloat((long)i);
                    result.putScalar(idx, value);
                    ++i;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    @Override
    public DataBuffer shapeInfoDataBuffer() {
        return this.shapeInformation;
    }

    @Override
    public INDArray subArray(ShapeOffsetResolution resolution) {
        long[] offsets = resolution.getOffsets();
        long[] shape = resolution.getShapes();
        int[] stride = LongUtils.toInts(resolution.getStrides());
        int[] flags = resolution.getFixed();
        flags = this.updateFlags(flags, shape);
        long offset = (int)(this.offset() + resolution.getOffset());
        int newRank = shape.length;
        long[] sparseOffsets = this.createSparseOffsets(offset);
        int[] newAxis = this.createHiddenDimensions(resolution.getPrependAxis());
        if (this.offset() + resolution.getOffset() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Offset of array can not be >= Integer.MAX_VALUE");
        }
        if (offsets.length != newRank) {
            throw new IllegalArgumentException("Invalid offset " + Arrays.toString(offsets));
        }
        if (stride.length != newRank) {
            throw new IllegalArgumentException("Invalid stride " + Arrays.toString(stride));
        }
        if (shape.length == this.rank() && Shape.contentEquals(shape, this.shapeOf())) {
            if (ArrayUtil.isZero((long[])offsets)) {
                return this;
            }
            throw new IllegalArgumentException("Invalid subArray offsets");
        }
        DataBuffer newSparseInformation = Nd4j.getSparseInfoProvider().createSparseInformation(flags, sparseOffsets, newAxis, this.underlyingRank());
        return this.create(this.values, this.indices, newSparseInformation, Arrays.copyOf(shape, shape.length));
    }

    public INDArray subArray(ShapeOffsetResolution resolution, ShapeOffsetResolution resolutionWithoutNewAxis) {
        return null;
    }

    private long[] createSparseOffsets(long offset) {
        int underlyingRank = this.sparseOffsets().length;
        long[] newOffsets = new long[this.rank()];
        List shapeList = Longs.asList((long[])this.shape());
        int penultimate = this.rank() - 1;
        for (int i = 0; i < penultimate; ++i) {
            long prod = ArrayUtil.prodLong(shapeList.subList(i + 1, this.rank()));
            newOffsets[i] = offset / prod;
            offset -= newOffsets[i] * prod;
        }
        newOffsets[this.rank() - 1] = offset % this.shape()[this.rank() - 1];
        long[] finalOffsets = new long[underlyingRank];
        int dimNotFixed = 0;
        for (int dim = 0; dim < underlyingRank; ++dim) {
            if (this.flags()[dim] == 1) {
                finalOffsets[dim] = this.sparseOffsets()[dim];
                continue;
            }
            finalOffsets[dim] = newOffsets[dimNotFixed] + (long)this.sparseOffsets()[dim];
            ++dimNotFixed;
        }
        return finalOffsets;
    }

    private int[] createHiddenDimensions(int[] newAxis) {
        if (newAxis == null || newAxis.length == 0) {
            return this.hiddenDimensions();
        }
        if (this.getNumHiddenDimension() == 0) {
            return newAxis;
        }
        int size = newAxis.length + this.hiddenDimensions().length;
        int[] newHiddenDim = new int[size];
        int newDim = 0;
        int actualArrayIdx = 0;
        for (int oldDim = 0; oldDim < this.getNumHiddenDimension(); ++oldDim) {
            while (newDim < newAxis.length && (oldDim >= this.getNumHiddenDimension() || newAxis[newDim] <= this.hiddenDimensions()[oldDim])) {
                newHiddenDim[actualArrayIdx] = newAxis[newDim] + oldDim;
                ++actualArrayIdx;
                ++newDim;
            }
            newHiddenDim[actualArrayIdx] = this.hiddenDimensions()[oldDim] + newDim;
            ++actualArrayIdx;
        }
        return newHiddenDim;
    }

    private int[] updateFlags(int[] viewFlags, long[] newShape) {
        int count = 0;
        for (int i = 0; i < viewFlags.length; ++i) {
            if (viewFlags[i] != 0) continue;
            ++count;
        }
        for (int dim = 0; dim < viewFlags.length; ++dim) {
            if (viewFlags[dim] != 1 || newShape[dim] != 1L || count >= 2) continue;
            viewFlags[dim] = 0;
        }
        int[] extendedFlags = new int[this.underlyingRank()];
        int notFixedDim = 0;
        for (int dim = 0; dim < this.underlyingRank(); ++dim) {
            int[] temp = this.flags();
            if (this.flags()[dim] == 0) {
                extendedFlags[dim] = viewFlags[notFixedDim];
                ++notFixedDim;
                continue;
            }
            extendedFlags[dim] = 1;
        }
        return extendedFlags;
    }

    private INDArray create(DataBuffer values, DataBuffer indices, DataBuffer sparseInfo, long[] newShape) {
        return Nd4j.createSparseCOO(values, indices, sparseInfo, newShape);
    }

    @Override
    public INDArray subArray(long[] offsets, int[] shape, int[] stride) {
        throw new UnsupportedOperationException();
    }

    public DataBuffer getUnderlyingIndicesOf(int i) {
        int from = this.underlyingRank() * i;
        int[] res = new int[this.underlyingRank()];
        for (int j = 0; j < this.underlyingRank(); ++j) {
            res[j] = this.indices.getInt((long)(from + j));
        }
        return Nd4j.getDataBufferFactory().createInt(res);
    }

    public DataBuffer getIndicesOf(int i) {
        int from = this.underlyingRank() * i;
        int to = from + this.underlyingRank();
        int[] arr = new int[this.rank];
        int j = 0;
        int k = 0;
        for (int dim = 0; dim < this.rank; ++dim) {
            if (k < this.hiddenDimensions().length && this.hiddenDimensions()[k] == j) {
                arr[dim] = 0;
                ++k;
                continue;
            }
            arr[dim] = this.indices.getInt((long)j);
            ++j;
        }
        return Nd4j.getDataBufferFactory().createInt(arr);
    }

    public boolean isZero(int ... indexes) {
        int i = 0;
        while ((long)i < this.length()) {
            int[] idx = this.getUnderlyingIndicesOf(i).asInt();
            if (Arrays.equals(idx, this.translateToPhysical(indexes))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isView() {
        return Shape.offset(this.shapeInformation) > 0 || this.data().originalDataBuffer() != null;
    }

    public int getNumHiddenDimension() {
        if (this.hiddenDimensions() == null || this.hiddenDimensions().length == 0) {
            throw new IllegalStateException("HiddenDimension array is malformed");
        }
        return this.hiddenDimensions()[0] == -1 ? 0 : this.hiddenDimensions().length;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public DataBuffer getValues() {
        return this.values;
    }

    public DataBuffer getIndices() {
        return this.indices;
    }

    @Override
    public INDArray putiColumnVector(INDArray columnVector) {
        return null;
    }

    @Override
    public INDArray putiRowVector(INDArray rowVector) {
        return null;
    }

    @Override
    public INDArray mmul(INDArray other, MMulTranspose mMulTranspose) {
        return null;
    }

    @Override
    public INDArray mmul(INDArray other, INDArray result, MMulTranspose mMulTranspose) {
        return null;
    }

    @Override
    public INDArray mmuli(INDArray other, MMulTranspose transpose) {
        return null;
    }

    @Override
    public INDArray mmuli(INDArray other, INDArray result, MMulTranspose transpose) {
        return null;
    }

    @Override
    public void setStride(long ... stride) {
    }

    @Override
    public void setShape(long ... shape) {
    }

    @Override
    public INDArray convertToFloats() {
        return null;
    }

    @Override
    public INDArray convertToDoubles() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

