/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.impl;

import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.blas.Level1;
import org.nd4j.linalg.api.blas.impl.BaseLevel;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarMultiplication;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.profiler.OpProfiler;

public abstract class BaseLevel1
extends BaseLevel
implements Level1 {
    @Override
    public double dot(long n, double alpha, INDArray X, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, X, Y);
        }
        if (X.isSparse() && !Y.isSparse()) {
            return Nd4j.getSparseBlasWrapper().level1().dot(n, alpha, X, Y);
        }
        if (!X.isSparse() && Y.isSparse()) {
            return Nd4j.getSparseBlasWrapper().level1().dot(n, alpha, Y, X);
        }
        if (X.isSparse() && Y.isSparse()) {
            return 0.0;
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, X, Y);
            return this.ddot(n, X, BlasBufferUtil.getBlasStride(X), Y, BlasBufferUtil.getBlasStride(Y));
        }
        if (X.data().dataType() == DataBuffer.Type.FLOAT) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, X, Y);
            return this.sdot(n, X, BlasBufferUtil.getBlasStride(X), Y, BlasBufferUtil.getBlasStride(Y));
        }
        DefaultOpExecutioner.validateDataType(DataBuffer.Type.HALF, X, Y);
        return this.hdot(n, X, BlasBufferUtil.getBlasStride(X), Y, BlasBufferUtil.getBlasStride(Y));
    }

    @Override
    public double dot(long n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        if (this.supportsDataBufferL1Ops()) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                return this.sdot(n, x, offsetX, incrX, y, offsetY, incrY);
            }
            if (x.dataType() == DataBuffer.Type.DOUBLE) {
                return this.ddot(n, x, offsetX, incrX, y, offsetY, incrY);
            }
            return this.hdot(n, x, offsetX, incrX, y, offsetY, incrY);
        }
        long[] shapex = new long[]{1L, n};
        long[] shapey = new long[]{1L, n};
        long[] stridex = new long[]{incrX, incrX};
        long[] stridey = new long[]{incrY, incrY};
        INDArray arrX = Nd4j.create(x, shapex, stridex, (long)offsetX, 'c');
        INDArray arrY = Nd4j.create(x, shapey, stridey, (long)offsetY, 'c');
        return this.dot(n, 0.0, arrX, arrY);
    }

    @Override
    public double nrm2(INDArray arr) {
        if (arr.isSparse()) {
            return Nd4j.getSparseBlasWrapper().level1().nrm2(arr);
        }
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, arr);
        }
        if (arr.isSparse()) {
            return Nd4j.getSparseBlasWrapper().level1().nrm2(arr);
        }
        if (arr.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, arr);
            return this.dnrm2(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
        }
        DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, arr);
        return this.snrm2(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
    }

    @Override
    public double asum(INDArray arr) {
        if (arr.isSparse()) {
            return Nd4j.getSparseBlasWrapper().level1().asum(arr);
        }
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, arr);
        }
        if (arr.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, arr);
            return this.dasum(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
        }
        if (arr.data().dataType() == DataBuffer.Type.FLOAT) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, arr);
            return this.sasum(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
        }
        DefaultOpExecutioner.validateDataType(DataBuffer.Type.HALF, arr);
        return this.hasum(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
    }

    @Override
    public double asum(long n, DataBuffer x, int offsetX, int incrX) {
        if (this.supportsDataBufferL1Ops()) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                return this.sasum(n, x, offsetX, incrX);
            }
            if (x.dataType() == DataBuffer.Type.DOUBLE) {
                return this.dasum(n, x, offsetX, incrX);
            }
            return this.hasum(n, x, offsetX, incrX);
        }
        long[] shapex = new long[]{1L, n};
        long[] stridex = new long[]{incrX, incrX};
        INDArray arrX = Nd4j.create(x, shapex, stridex, (long)offsetX, 'c');
        return this.asum(arrX);
    }

    @Override
    public int iamax(long n, INDArray arr, int stride) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, arr);
        }
        if (arr.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, arr);
            return this.idamax(n, arr, stride);
        }
        DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, arr);
        return this.isamax(n, arr, stride);
    }

    @Override
    public int iamax(long n, DataBuffer x, int offsetX, int incrX) {
        if (this.supportsDataBufferL1Ops()) {
            if (x.dataType() == DataBuffer.Type.FLOAT) {
                return this.isamax(n, x, offsetX, incrX);
            }
            return this.isamax(n, x, offsetX, incrX);
        }
        long[] shapex = new long[]{1L, n};
        long[] stridex = new long[]{incrX, incrX};
        INDArray arrX = Nd4j.create(x, shapex, stridex, (long)offsetX, 'c');
        return this.iamax(n, arrX, incrX);
    }

    @Override
    public int iamax(INDArray arr) {
        if (arr.isSparse()) {
            return Nd4j.getSparseBlasWrapper().level1().iamax(arr);
        }
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, arr);
        }
        if (arr.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, arr);
            return this.idamax(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
        }
        DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, arr);
        return this.isamax(arr.length(), arr, BlasBufferUtil.getBlasStride(arr));
    }

    @Override
    public int iamin(INDArray arr) {
        if (arr.isSparse()) {
            return Nd4j.getSparseBlasWrapper().level1().iamin(arr);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void swap(INDArray x, INDArray y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, x, y);
        }
        if (x.isSparse() || y.isSparse()) {
            Nd4j.getSparseBlasWrapper().level1().swap(x, y);
            return;
        }
        if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, x, y);
            this.dswap(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, x, y);
            this.sswap(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        }
    }

    @Override
    public void copy(INDArray x, INDArray y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, x, y);
        }
        if (x.isSparse() || y.isSparse()) {
            Nd4j.getSparseBlasWrapper().level1().copy(x, y);
            return;
        }
        if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, x, y);
            this.dcopy(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, x, y);
            this.scopy(x.length(), x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        }
    }

    @Override
    public void copy(long n, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        if (this.supportsDataBufferL1Ops()) {
            if (x.dataType() == DataBuffer.Type.DOUBLE) {
                this.dcopy(n, x, offsetX, incrX, y, offsetY, incrY);
            } else {
                this.scopy(n, x, offsetX, incrX, y, offsetY, incrY);
            }
        } else {
            long[] shapex = new long[]{1L, n};
            long[] shapey = new long[]{1L, n};
            long[] stridex = new long[]{incrX, incrX};
            long[] stridey = new long[]{incrY, incrY};
            INDArray arrX = Nd4j.create(x, shapex, stridex, (long)offsetX, 'c');
            INDArray arrY = Nd4j.create(x, shapey, stridey, (long)offsetY, 'c');
            this.copy(arrX, arrY);
        }
    }

    @Override
    public void axpy(long n, double alpha, INDArray x, INDArray y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, x, y);
        }
        if (x.isSparse() && !y.isSparse()) {
            Nd4j.getSparseBlasWrapper().level1().axpy(n, alpha, x, y);
        } else if (x.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, x, y);
            this.daxpy(n, alpha, x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        } else if (x.data().dataType() == DataBuffer.Type.FLOAT) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, x, y);
            this.saxpy(n, (float)alpha, x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.HALF, x, y);
            this.haxpy(n, (float)alpha, x, BlasBufferUtil.getBlasStride(x), y, BlasBufferUtil.getBlasStride(y));
        }
    }

    @Override
    public void axpy(long n, double alpha, DataBuffer x, int offsetX, int incrX, DataBuffer y, int offsetY, int incrY) {
        if (this.supportsDataBufferL1Ops()) {
            if (x.dataType() == DataBuffer.Type.DOUBLE) {
                this.daxpy(n, alpha, x, offsetX, incrX, y, offsetY, incrY);
            } else if (x.dataType() == DataBuffer.Type.FLOAT) {
                this.saxpy(n, (float)alpha, x, offsetX, incrX, y, offsetY, incrY);
            } else {
                this.haxpy(n, (float)alpha, x, offsetX, incrX, y, offsetY, incrY);
            }
        } else {
            long[] shapex = new long[]{1L, n};
            long[] shapey = new long[]{1L, n};
            long[] stridex = new long[]{incrX, incrX};
            long[] stridey = new long[]{incrY, incrY};
            INDArray arrX = Nd4j.create(x, shapex, stridex, (long)offsetX, 'c');
            INDArray arrY = Nd4j.create(x, shapey, stridey, (long)offsetY, 'c');
            this.axpy(n, alpha, arrX, arrY);
        }
    }

    @Override
    public void rotg(INDArray a, INDArray b, INDArray c, INDArray s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rot(long N, INDArray X, INDArray Y, double c, double s) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, X, Y);
        }
        if (X.isSparse() && !Y.isSparse()) {
            Nd4j.getSparseBlasWrapper().level1().rot(N, X, Y, c, s);
        } else if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, X, Y);
            this.drot(N, X, BlasBufferUtil.getBlasStride(X), Y, BlasBufferUtil.getBlasStride(X), c, s);
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, X, Y);
            this.srot(N, X, BlasBufferUtil.getBlasStride(X), Y, BlasBufferUtil.getBlasStride(X), (float)c, (float)s);
        }
    }

    @Override
    public void rotmg(INDArray d1, INDArray d2, INDArray b1, double b2, INDArray P) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scal(long N, double alpha, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, X);
        }
        if (X.isSparse()) {
            Nd4j.getSparseBlasWrapper().level1().scal(N, alpha, X);
        } else if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.dscal(N, alpha, X, BlasBufferUtil.getBlasStride(X));
        } else if (X.data().dataType() == DataBuffer.Type.FLOAT) {
            this.sscal(N, (float)alpha, X, BlasBufferUtil.getBlasStride(X));
        } else if (X.data().dataType() == DataBuffer.Type.HALF) {
            Nd4j.getExecutioner().exec(new ScalarMultiplication(X, alpha));
        }
    }

    protected abstract float sdsdot(long var1, float var3, INDArray var4, int var5, INDArray var6, int var7);

    protected abstract double dsdot(long var1, INDArray var3, int var4, INDArray var5, int var6);

    protected abstract float hdot(long var1, INDArray var3, int var4, INDArray var5, int var6);

    protected abstract float hdot(long var1, DataBuffer var3, int var4, int var5, DataBuffer var6, int var7, int var8);

    protected abstract float sdot(long var1, INDArray var3, int var4, INDArray var5, int var6);

    protected abstract float sdot(long var1, DataBuffer var3, int var4, int var5, DataBuffer var6, int var7, int var8);

    protected abstract double ddot(long var1, INDArray var3, int var4, INDArray var5, int var6);

    protected abstract double ddot(long var1, DataBuffer var3, int var4, int var5, DataBuffer var6, int var7, int var8);

    protected abstract float snrm2(long var1, INDArray var3, int var4);

    protected abstract float hasum(long var1, INDArray var3, int var4);

    protected abstract float hasum(long var1, DataBuffer var3, int var4, int var5);

    protected abstract float sasum(long var1, INDArray var3, int var4);

    protected abstract float sasum(long var1, DataBuffer var3, int var4, int var5);

    protected abstract double dnrm2(long var1, INDArray var3, int var4);

    protected abstract double dasum(long var1, INDArray var3, int var4);

    protected abstract double dasum(long var1, DataBuffer var3, int var4, int var5);

    protected abstract int isamax(long var1, INDArray var3, int var4);

    protected abstract int isamax(long var1, DataBuffer var3, int var4, int var5);

    protected abstract int idamax(long var1, INDArray var3, int var4);

    protected abstract int idamax(long var1, DataBuffer var3, int var4, int var5);

    protected abstract void sswap(long var1, INDArray var3, int var4, INDArray var5, int var6);

    protected abstract void scopy(long var1, INDArray var3, int var4, INDArray var5, int var6);

    protected abstract void scopy(long var1, DataBuffer var3, int var4, int var5, DataBuffer var6, int var7, int var8);

    protected abstract void haxpy(long var1, float var3, INDArray var4, int var5, INDArray var6, int var7);

    protected abstract void saxpy(long var1, float var3, INDArray var4, int var5, INDArray var6, int var7);

    protected abstract void haxpy(long var1, float var3, DataBuffer var4, int var5, int var6, DataBuffer var7, int var8, int var9);

    protected abstract void saxpy(long var1, float var3, DataBuffer var4, int var5, int var6, DataBuffer var7, int var8, int var9);

    protected abstract void dswap(long var1, INDArray var3, int var4, INDArray var5, int var6);

    protected abstract void dcopy(long var1, INDArray var3, int var4, INDArray var5, int var6);

    protected abstract void dcopy(long var1, DataBuffer var3, int var4, int var5, DataBuffer var6, int var7, int var8);

    protected abstract void daxpy(long var1, double var3, INDArray var5, int var6, INDArray var7, int var8);

    protected abstract void daxpy(long var1, double var3, DataBuffer var5, int var6, int var7, DataBuffer var8, int var9, int var10);

    protected abstract void srotg(float var1, float var2, float var3, float var4);

    protected abstract void srotmg(float var1, float var2, float var3, float var4, INDArray var5);

    protected abstract void srot(long var1, INDArray var3, int var4, INDArray var5, int var6, float var7, float var8);

    protected abstract void srotm(long var1, INDArray var3, int var4, INDArray var5, int var6, INDArray var7);

    protected abstract void drotg(double var1, double var3, double var5, double var7);

    protected abstract void drotmg(double var1, double var3, double var5, double var7, INDArray var9);

    protected abstract void drot(long var1, INDArray var3, int var4, INDArray var5, int var6, double var7, double var9);

    protected abstract void drotm(long var1, INDArray var3, int var4, INDArray var5, int var6, INDArray var7);

    protected abstract void sscal(long var1, float var3, INDArray var4, int var5);

    protected abstract void dscal(long var1, double var3, INDArray var5, int var6);

    @Override
    public boolean supportsDataBufferL1Ops() {
        return true;
    }
}

