/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.databind.deser.std;

import java.io.IOException;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.core.JsonToken;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.JsonMappingException;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.deser.std.StdDeserializer;
import org.nd4j.shade.jackson.databind.jsontype.TypeDeserializer;
import org.nd4j.shade.jackson.databind.node.ArrayNode;
import org.nd4j.shade.jackson.databind.node.JsonNodeFactory;
import org.nd4j.shade.jackson.databind.node.ObjectNode;

abstract class BaseNodeDeserializer<T extends JsonNode>
extends StdDeserializer<T> {
    public BaseNodeDeserializer(Class<T> vc) {
        super(vc);
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    protected void _reportProblem(JsonParser jp, String msg) throws JsonMappingException {
        throw new JsonMappingException(msg, jp.getTokenLocation());
    }

    @Deprecated
    protected void _handleDuplicateField(String fieldName, ObjectNode objectNode, JsonNode oldValue, JsonNode newValue) throws JsonProcessingException {
    }

    protected void _handleDuplicateField(JsonParser jp, DeserializationContext ctxt, JsonNodeFactory nodeFactory, String fieldName, ObjectNode objectNode, JsonNode oldValue, JsonNode newValue) throws JsonProcessingException {
        if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY)) {
            this._reportProblem(jp, "Duplicate field '" + fieldName + "' for ObjectNode: not allowed when FAIL_ON_READING_DUP_TREE_KEY enabled");
        }
        this._handleDuplicateField(fieldName, objectNode, oldValue, newValue);
    }

    protected final ObjectNode deserializeObject(JsonParser jp, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        ObjectNode node = nodeFactory.objectNode();
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        while (t == JsonToken.FIELD_NAME) {
            JsonNode value;
            String fieldName = jp.getCurrentName();
            t = jp.nextToken();
            switch (t.id()) {
                case 1: {
                    value = this.deserializeObject(jp, ctxt, nodeFactory);
                    break;
                }
                case 3: {
                    value = this.deserializeArray(jp, ctxt, nodeFactory);
                    break;
                }
                case 6: {
                    value = nodeFactory.textNode(jp.getText());
                    break;
                }
                case 7: {
                    value = this._fromInt(jp, ctxt, nodeFactory);
                    break;
                }
                case 9: {
                    value = nodeFactory.booleanNode(true);
                    break;
                }
                case 10: {
                    value = nodeFactory.booleanNode(false);
                    break;
                }
                case 11: {
                    value = nodeFactory.nullNode();
                    break;
                }
                default: {
                    value = this.deserializeAny(jp, ctxt, nodeFactory);
                }
            }
            JsonNode old = node.replace(fieldName, value);
            if (old != null) {
                this._handleDuplicateField(jp, ctxt, nodeFactory, fieldName, node, old, value);
            }
            t = jp.nextToken();
        }
        return node;
    }

    protected final ArrayNode deserializeArray(JsonParser jp, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        ArrayNode node = nodeFactory.arrayNode();
        block10: while (true) {
            JsonToken t;
            if ((t = jp.nextToken()) == null) {
                throw ctxt.mappingException("Unexpected end-of-input when binding data into ArrayNode");
            }
            switch (t.id()) {
                case 1: {
                    node.add(this.deserializeObject(jp, ctxt, nodeFactory));
                    continue block10;
                }
                case 3: {
                    node.add(this.deserializeArray(jp, ctxt, nodeFactory));
                    continue block10;
                }
                case 4: {
                    return node;
                }
                case 6: {
                    node.add(nodeFactory.textNode(jp.getText()));
                    continue block10;
                }
                case 7: {
                    node.add(this._fromInt(jp, ctxt, nodeFactory));
                    continue block10;
                }
                case 9: {
                    node.add(nodeFactory.booleanNode(true));
                    continue block10;
                }
                case 10: {
                    node.add(nodeFactory.booleanNode(false));
                    continue block10;
                }
                case 11: {
                    node.add(nodeFactory.nullNode());
                    continue block10;
                }
            }
            node.add(this.deserializeAny(jp, ctxt, nodeFactory));
        }
    }

    protected final JsonNode deserializeAny(JsonParser jp, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        switch (jp.getCurrentTokenId()) {
            case 1: 
            case 2: {
                return this.deserializeObject(jp, ctxt, nodeFactory);
            }
            case 3: {
                return this.deserializeArray(jp, ctxt, nodeFactory);
            }
            case 5: {
                return this.deserializeObject(jp, ctxt, nodeFactory);
            }
            case 12: {
                return this._fromEmbedded(jp, ctxt, nodeFactory);
            }
            case 6: {
                return nodeFactory.textNode(jp.getText());
            }
            case 7: {
                return this._fromInt(jp, ctxt, nodeFactory);
            }
            case 8: {
                return this._fromFloat(jp, ctxt, nodeFactory);
            }
            case 9: {
                return nodeFactory.booleanNode(true);
            }
            case 10: {
                return nodeFactory.booleanNode(false);
            }
            case 11: {
                return nodeFactory.nullNode();
            }
        }
        throw ctxt.mappingException(this.handledType());
    }

    protected final JsonNode _fromInt(JsonParser jp, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonParser.NumberType nt = jp.getNumberType();
        if (nt == JsonParser.NumberType.BIG_INTEGER || ctxt.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
            return nodeFactory.numberNode(jp.getBigIntegerValue());
        }
        if (nt == JsonParser.NumberType.INT) {
            return nodeFactory.numberNode(jp.getIntValue());
        }
        return nodeFactory.numberNode(jp.getLongValue());
    }

    protected final JsonNode _fromFloat(JsonParser jp, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonParser.NumberType nt = jp.getNumberType();
        if (nt == JsonParser.NumberType.BIG_DECIMAL || ctxt.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            return nodeFactory.numberNode(jp.getDecimalValue());
        }
        return nodeFactory.numberNode(jp.getDoubleValue());
    }

    protected final JsonNode _fromEmbedded(JsonParser jp, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        Object ob = jp.getEmbeddedObject();
        if (ob == null) {
            return nodeFactory.nullNode();
        }
        Class<?> type = ob.getClass();
        if (type == byte[].class) {
            return nodeFactory.binaryNode((byte[])ob);
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return (JsonNode)ob;
        }
        return nodeFactory.pojoNode(ob);
    }
}

