/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf.support;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ibatis.builder.annotation.ProviderContext;
import org.apache.ibatis.io.Resources;
import org.mybatis.scripting.thymeleaf.ThymeleafLanguageDriverConfig;

public class TemplateFilePathProvider {
    private static final PathGenerator DEFAULT_PATH_GENERATOR = TemplateFilePathProvider::generateTemplatePath;
    private static final ThymeleafLanguageDriverConfig DEFAULT_LANGUAGE_DRIVER_CONFIG = ThymeleafLanguageDriverConfig.newInstance();
    private static PathGenerator pathGenerator = DEFAULT_PATH_GENERATOR;
    private static ThymeleafLanguageDriverConfig languageDriverConfig = DEFAULT_LANGUAGE_DRIVER_CONFIG;
    private static ConcurrentMap<ProviderContext, String> cache = new ConcurrentHashMap<ProviderContext, String>();

    private TemplateFilePathProvider() {
    }

    public static void setCustomTemplateFilePathGenerator(PathGenerator pathGenerator) {
        TemplateFilePathProvider.pathGenerator = Optional.ofNullable(pathGenerator).orElse(DEFAULT_PATH_GENERATOR);
    }

    public static void setLanguageDriverConfig(ThymeleafLanguageDriverConfig languageDriverConfig) {
        TemplateFilePathProvider.languageDriverConfig = Optional.ofNullable(languageDriverConfig).orElse(DEFAULT_LANGUAGE_DRIVER_CONFIG);
    }

    public static String provideSql(ProviderContext context) {
        return languageDriverConfig.getTemplateFile().getPathProvider().isCacheEnabled() ? cache.computeIfAbsent(context, c -> TemplateFilePathProvider.providePath(c.getMapperType(), c.getMapperMethod(), c.getDatabaseId())) : TemplateFilePathProvider.providePath(context.getMapperType(), context.getMapperMethod(), context.getDatabaseId());
    }

    public static void clearCache() {
        cache.clear();
    }

    static String providePath(Class<?> mapperType, Method mapperMethod, String databaseId) {
        boolean fallbackDeclaringClass = mapperType != mapperMethod.getDeclaringClass();
        boolean fallbackDatabase = databaseId != null;
        String path = pathGenerator.generatePath(mapperType, mapperMethod, databaseId);
        if (TemplateFilePathProvider.exists(path)) {
            return path;
        }
        if (fallbackDatabase && TemplateFilePathProvider.exists(path = pathGenerator.generatePath(mapperType, mapperMethod, null))) {
            return path;
        }
        if (fallbackDeclaringClass) {
            path = pathGenerator.generatePath(mapperMethod.getDeclaringClass(), mapperMethod, databaseId);
            if (TemplateFilePathProvider.exists(path)) {
                return path;
            }
            if (fallbackDatabase && TemplateFilePathProvider.exists(path = pathGenerator.generatePath(mapperMethod.getDeclaringClass(), mapperMethod, null))) {
                return path;
            }
        }
        throw new IllegalStateException("The SQL template file not found. mapperType:[" + String.valueOf(mapperType) + "] mapperMethod:[" + String.valueOf(mapperMethod) + "] databaseId:[" + databaseId + "]");
    }

    private static String generateTemplatePath(Class<?> type, Method method, String databaseId) {
        Package pkg = type.getPackage();
        String packageName = pkg == null ? "" : pkg.getName();
        String className = type.getName().substring(packageName.length() + (packageName.isEmpty() ? 0 : 1));
        ThymeleafLanguageDriverConfig.TemplateFileConfig.PathProviderConfig pathProviderConfig = languageDriverConfig.getTemplateFile().getPathProvider();
        StringBuilder path = new StringBuilder();
        if (!pathProviderConfig.getPrefix().isEmpty()) {
            path.append(pathProviderConfig.getPrefix());
        }
        if (pathProviderConfig.isIncludesPackagePath() && !packageName.isEmpty()) {
            path.append(packageName.replace('.', '/')).append('/');
        }
        path.append(className);
        if (pathProviderConfig.isSeparateDirectoryPerMapper()) {
            path.append('/');
            if (pathProviderConfig.isIncludesMapperNameWhenSeparateDirectory()) {
                path.append(className).append('-');
            }
        } else {
            path.append('-');
        }
        path.append(method.getName());
        if (databaseId != null) {
            path.append('-').append(databaseId);
        }
        path.append(".sql");
        return path.toString();
    }

    private static boolean exists(String path) {
        String basePath = languageDriverConfig.getTemplateFile().getBaseDir();
        String actualPath = basePath.isEmpty() ? path : basePath + (basePath.endsWith("/") ? "" : "/") + path;
        try {
            Resources.getResourceURL((String)actualPath);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @FunctionalInterface
    public static interface PathGenerator {
        public String generatePath(Class<?> var1, Method var2, String var3);
    }
}

