/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.thymeleaf;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.session.Configuration;
import org.mybatis.scripting.thymeleaf.MyBatisBindingContext;
import org.mybatis.scripting.thymeleaf.SqlGenerator;
import org.thymeleaf.context.IContext;

class ThymeleafSqlSource
implements SqlSource {
    private final Configuration configuration;
    private final SqlGenerator sqlGenerator;
    private final SqlSourceBuilder sqlSourceBuilder;
    private final String sqlTemplate;
    private final Class<?> parameterType;

    ThymeleafSqlSource(Configuration configuration, SqlGenerator sqlGenerator, String sqlTemplate, Class<?> parameterType) {
        this.configuration = configuration;
        this.sqlGenerator = sqlGenerator;
        this.sqlTemplate = sqlTemplate;
        this.parameterType = parameterType;
        this.sqlSourceBuilder = new SqlSourceBuilder(configuration);
    }

    public BoundSql getBoundSql(Object parameterObject) {
        Class<Object> processingParameterType = this.parameterType == null ? (parameterObject == null ? Object.class : parameterObject.getClass()) : this.parameterType;
        DynamicContext dynamicContext = new DynamicContext(this.configuration, parameterObject);
        Map customVariables = dynamicContext.getBindings();
        customVariables.put("__configuration__", this.configuration);
        customVariables.put("__dynamicContext__", dynamicContext);
        customVariables.put("__processingParameterType__", processingParameterType);
        String sql = this.sqlGenerator.generate(this.sqlTemplate, parameterObject, (arg_0, arg_1) -> ((DynamicContext)dynamicContext).bind(arg_0, arg_1), customVariables);
        SqlSource sqlSource = this.sqlSourceBuilder.parse(sql, processingParameterType, dynamicContext.getBindings());
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        dynamicContext.getBindings().forEach((arg_0, arg_1) -> ((BoundSql)boundSql).setAdditionalParameter(arg_0, arg_1));
        return boundSql;
    }

    private static class TemporaryTakeoverKeys {
        private static final String CONFIGURATION = "__configuration__";
        private static final String DYNAMIC_CONTEXT = "__dynamicContext__";
        private static final String PROCESSING_PARAMETER_TYPE = "__processingParameterType__";

        private TemporaryTakeoverKeys() {
        }
    }

    private static class MetaClassBasedContext
    extends AbstractContext {
        private final Object parameterObject;
        private final MetaClass parameterMetaClass;
        private final Class<?> parameterType;

        private MetaClassBasedContext(Object parameterObject, MetaClass parameterMetaClass, Class<?> parameterType, DynamicContext dynamicContext, Properties configurationProperties) {
            super(dynamicContext, configurationProperties);
            this.parameterObject = parameterObject;
            this.parameterMetaClass = parameterMetaClass;
            this.parameterType = parameterType;
            this.addVariableNames(Arrays.asList(parameterMetaClass.getGetterNames()));
        }

        @Override
        public Object getParameterValue(String name) {
            try {
                return this.parameterMetaClass.getGetInvoker(name).invoke(this.parameterObject, null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(String.format("Cannot get a value for property named '%s' in '%s'", name, this.parameterType), e);
            }
        }
    }

    private static class MapBasedContext
    extends AbstractContext {
        private final Map<String, Object> variables;

        private MapBasedContext(Map<String, Object> parameterMap, DynamicContext dynamicContext, Properties configurationProperties) {
            super(dynamicContext, configurationProperties);
            this.variables = parameterMap;
            this.addVariableNames(parameterMap.keySet());
        }

        @Override
        public Object getParameterValue(String name) {
            return this.variables.get(name);
        }
    }

    private static abstract class AbstractContext
    implements IContext {
        private final DynamicContext dynamicContext;
        private final Properties configurationProperties;
        private final Set<String> variableNames;

        private AbstractContext(DynamicContext dynamicContext, Properties configurationProperties) {
            this.dynamicContext = dynamicContext;
            this.configurationProperties = configurationProperties;
            this.variableNames = new HashSet<String>();
            this.addVariableNames(dynamicContext.getBindings().keySet());
            Optional.ofNullable(configurationProperties).ifPresent(v -> this.addVariableNames(v.stringPropertyNames()));
        }

        void addVariableNames(Collection<String> names) {
            this.variableNames.addAll(names);
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public boolean containsVariable(String name) {
            return this.variableNames.contains(name);
        }

        public Set<String> getVariableNames() {
            return this.variableNames;
        }

        public Object getVariable(String name) {
            if (this.dynamicContext.getBindings().containsKey(name)) {
                return this.dynamicContext.getBindings().get(name);
            }
            if (this.configurationProperties != null && this.configurationProperties.containsKey(name)) {
                return this.configurationProperties.getProperty(name);
            }
            return this.getParameterValue(name);
        }

        abstract Object getParameterValue(String var1);
    }

    static class ContextFactory
    implements BiFunction<Object, Map<String, Object>, IContext> {
        ContextFactory() {
        }

        @Override
        public IContext apply(Object parameter, Map<String, Object> customVariable) {
            AbstractContext context;
            Configuration configuration = (Configuration)customVariable.remove("__configuration__");
            DynamicContext dynamicContext = (DynamicContext)customVariable.remove("__dynamicContext__");
            Class processingParameterType = (Class)customVariable.remove("__processingParameterType__");
            MyBatisBindingContext bindingContext = new MyBatisBindingContext(parameter != null && configuration.getTypeHandlerRegistry().hasTypeHandler(processingParameterType));
            dynamicContext.bind(MyBatisBindingContext.CONTEXT_VARIABLE_NAME, (Object)bindingContext);
            if (parameter instanceof Map) {
                Map map = (Map)parameter;
                context = new MapBasedContext(map, dynamicContext, configuration.getVariables());
            } else {
                MetaClass metaClass = MetaClass.forClass((Class)processingParameterType, (ReflectorFactory)configuration.getReflectorFactory());
                context = new MetaClassBasedContext(parameter, metaClass, processingParameterType, dynamicContext, configuration.getVariables());
            }
            return context;
        }
    }
}

