/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import org.msgpack.core.ExtensionTypeHeader;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;

public class TimestampExtensionModule {
    public static final byte EXT_TYPE = -1;
    public static final SimpleModule INSTANCE = new SimpleModule("msgpack-ext-timestamp");

    private TimestampExtensionModule() {
    }

    static {
        INSTANCE.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer(Instant.class));
        INSTANCE.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer(Instant.class));
    }

    private static class InstantDeserializer
    extends StdDeserializer<Instant> {
        protected InstantDeserializer(Class<?> clazz) {
            super(clazz);
        }

        public Instant deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            MessagePackExtensionType messagePackExtensionType = (MessagePackExtensionType)jsonParser.readValueAs(MessagePackExtensionType.class);
            if (messagePackExtensionType.getType() != -1) {
                throw new RuntimeException(String.format("Unexpected extension type (0x%X) for Instant object", messagePackExtensionType.getType()));
            }
            try (MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker((byte[])messagePackExtensionType.getData());){
                Instant instant = messageUnpacker.unpackTimestamp(new ExtensionTypeHeader(-1, messagePackExtensionType.getData().length));
                return instant;
            }
        }
    }

    private static class InstantSerializer
    extends StdSerializer<Instant> {
        protected InstantSerializer(Class<Instant> clazz) {
            super(clazz);
        }

        public void serialize(Instant instant, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (MessagePacker messagePacker = MessagePack.newDefaultPacker((OutputStream)byteArrayOutputStream);){
                messagePacker.packTimestamp(instant);
            }
            messagePacker = MessagePack.newDefaultUnpacker((byte[])byteArrayOutputStream.toByteArray());
            var6_6 = null;
            try {
                ExtensionTypeHeader extensionTypeHeader = messagePacker.unpackExtensionTypeHeader();
                byte[] byArray = messagePacker.readPayload(extensionTypeHeader.getLength());
                MessagePackExtensionType messagePackExtensionType = new MessagePackExtensionType(-1, byArray);
                jsonGenerator.writeObject((Object)messagePackExtensionType);
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (messagePacker != null) {
                    if (var6_6 != null) {
                        try {
                            messagePacker.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        messagePacker.close();
                    }
                }
            }
        }
    }
}

