/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBObjectCodec;
import com.mongodb.MongoNamespace;
import com.mongodb.operation.GroupOperation;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonJavaScript;
import org.bson.codecs.Decoder;
import org.bson.codecs.Encoder;

public class GroupCommand {
    private final String collectionName;
    private final DBObject keys;
    private final DBObject condition;
    private final DBObject initial;
    private final String reduce;
    private final String finalize;

    public GroupCommand(DBCollection collection, DBObject keys, DBObject condition, DBObject initial, String reduce, String finalize) {
        this.collectionName = collection.getName();
        this.keys = keys;
        this.condition = condition;
        this.initial = initial;
        this.reduce = reduce;
        this.finalize = finalize;
    }

    public DBObject toDBObject() {
        BasicDBObject args = new BasicDBObject("ns", this.collectionName).append("key", this.keys).append("cond", this.condition).append("$reduce", this.reduce).append("initial", this.initial);
        if (this.finalize != null) {
            args.put("finalize", this.finalize);
        }
        return new BasicDBObject("group", args);
    }

    GroupOperation<DBObject> toOperation(MongoNamespace namespace, DBObjectCodec codec) {
        if (this.initial == null) {
            throw new IllegalArgumentException("Group command requires an initial document for the aggregate result");
        }
        if (this.reduce == null) {
            throw new IllegalArgumentException("Group command requires a reduce function for the aggregate result");
        }
        GroupOperation operation = new GroupOperation(namespace, new BsonJavaScript(this.reduce), (BsonDocument)new BsonDocumentWrapper((Object)this.initial, (Encoder)codec), (Decoder)codec);
        if (this.keys != null) {
            operation.key((BsonDocument)new BsonDocumentWrapper((Object)this.keys, (Encoder)codec));
        }
        if (this.condition != null) {
            operation.filter((BsonDocument)new BsonDocumentWrapper((Object)this.condition, (Encoder)codec));
        }
        if (this.finalize != null) {
            operation.finalizeFunction(new BsonJavaScript(this.finalize));
        }
        return operation;
    }
}

