/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.mql;

import com.mongodb.annotations.Beta;
import com.mongodb.annotations.Reason;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.mql.Branches;
import com.mongodb.client.model.mql.BranchesTerminal;
import com.mongodb.client.model.mql.MqlArray;
import com.mongodb.client.model.mql.MqlBoolean;
import com.mongodb.client.model.mql.MqlDate;
import com.mongodb.client.model.mql.MqlInteger;
import com.mongodb.client.model.mql.MqlMap;
import com.mongodb.client.model.mql.MqlNumber;
import com.mongodb.client.model.mql.MqlString;
import com.mongodb.client.model.mql.MqlValue;
import com.mongodb.client.model.mql.MqlValues;
import java.time.Instant;
import java.util.function.Function;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Reason.CLIENT})
public interface MqlDocument
extends MqlValue {
    public MqlBoolean hasField(String var1);

    public MqlDocument setField(String var1, MqlValue var2);

    public MqlDocument unsetField(String var1);

    public MqlValue getField(String var1);

    public MqlBoolean getBoolean(String var1);

    public MqlBoolean getBoolean(String var1, MqlBoolean var2);

    default public MqlBoolean getBoolean(String fieldName, boolean other) {
        Assertions.notNull("fieldName", fieldName);
        return this.getBoolean(fieldName, MqlValues.of(other));
    }

    public MqlNumber getNumber(String var1);

    public MqlNumber getNumber(String var1, MqlNumber var2);

    default public MqlNumber getNumber(String fieldName, Number other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getNumber(fieldName, MqlValues.numberToMqlNumber(other));
    }

    public MqlInteger getInteger(String var1);

    public MqlInteger getInteger(String var1, MqlInteger var2);

    default public MqlInteger getInteger(String fieldName, int other) {
        Assertions.notNull("fieldName", fieldName);
        return this.getInteger(fieldName, MqlValues.of(other));
    }

    default public MqlInteger getInteger(String fieldName, long other) {
        Assertions.notNull("fieldName", fieldName);
        return this.getInteger(fieldName, MqlValues.of(other));
    }

    public MqlString getString(String var1);

    public MqlString getString(String var1, MqlString var2);

    default public MqlString getString(String fieldName, String other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getString(fieldName, MqlValues.of(other));
    }

    public MqlDate getDate(String var1);

    public MqlDate getDate(String var1, MqlDate var2);

    default public MqlDate getDate(String fieldName, Instant other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getDate(fieldName, MqlValues.of(other));
    }

    public MqlDocument getDocument(String var1);

    public MqlDocument getDocument(String var1, MqlDocument var2);

    default public MqlDocument getDocument(String fieldName, Bson other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getDocument(fieldName, MqlValues.of(other));
    }

    public <T extends MqlValue> MqlMap<T> getMap(String var1);

    public <T extends MqlValue> MqlMap<T> getMap(String var1, MqlMap<? extends T> var2);

    default public <T extends MqlValue> MqlMap<T> getMap(String fieldName, Bson other) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("other", other);
        return this.getMap(fieldName, MqlValues.ofMap(other));
    }

    public <T extends MqlValue> MqlArray<T> getArray(String var1);

    public <T extends MqlValue> MqlArray<T> getArray(String var1, MqlArray<? extends T> var2);

    public MqlDocument merge(MqlDocument var1);

    public <T extends MqlValue> MqlMap<T> asMap();

    public <R extends MqlValue> R passDocumentTo(Function<? super MqlDocument, ? extends R> var1);

    public <R extends MqlValue> R switchDocumentOn(Function<Branches<MqlDocument>, ? extends BranchesTerminal<MqlDocument, ? extends R>> var1);
}

