/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.SimpleExpression;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Projections {
    private Projections() {
    }

    public static <TExpression> Bson computed(String fieldName, TExpression expression) {
        return new SimpleExpression<TExpression>(fieldName, expression);
    }

    public static Bson computedSearchMeta(String fieldName) {
        return Projections.computed(fieldName, "$$SEARCH_META");
    }

    public static Bson include(String ... fieldNames) {
        return Projections.include(Arrays.asList(fieldNames));
    }

    public static Bson include(List<String> fieldNames) {
        return Projections.combine(fieldNames, (BsonValue)new BsonInt32(1));
    }

    public static Bson exclude(String ... fieldNames) {
        return Projections.exclude(Arrays.asList(fieldNames));
    }

    public static Bson exclude(List<String> fieldNames) {
        return Projections.combine(fieldNames, (BsonValue)new BsonInt32(0));
    }

    public static Bson excludeId() {
        return new BsonDocument("_id", (BsonValue)new BsonInt32(0));
    }

    public static Bson elemMatch(String fieldName) {
        return new BsonDocument(fieldName + ".$", (BsonValue)new BsonInt32(1));
    }

    public static Bson elemMatch(String fieldName, Bson filter) {
        return new ElemMatchFilterProjection(fieldName, filter);
    }

    public static Bson meta(String fieldName, String metaFieldName) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$meta", (BsonValue)new BsonString(metaFieldName)));
    }

    public static Bson metaTextScore(String fieldName) {
        return Projections.meta(fieldName, "textScore");
    }

    public static Bson metaSearchScore(String fieldName) {
        return Projections.meta(fieldName, "searchScore");
    }

    public static Bson metaSearchHighlights(String fieldName) {
        return Projections.meta(fieldName, "searchHighlights");
    }

    public static Bson slice(String fieldName, int limit) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$slice", (BsonValue)new BsonInt32(limit)));
    }

    public static Bson slice(String fieldName, int skip, int limit) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$slice", (BsonValue)new BsonArray(Arrays.asList(new BsonInt32(skip), new BsonInt32(limit)))));
    }

    public static Bson fields(Bson ... projections) {
        return Projections.fields(Arrays.asList(projections));
    }

    public static Bson fields(List<? extends Bson> projections) {
        Assertions.notNull("projections", projections);
        return new FieldsProjection(projections);
    }

    private static Bson combine(List<String> fieldNames, BsonValue value) {
        BsonDocument document = new BsonDocument();
        for (String fieldName : fieldNames) {
            document.remove((Object)fieldName);
            document.append(fieldName, value);
        }
        return document;
    }

    private static class ElemMatchFilterProjection
    implements Bson {
        private final String fieldName;
        private final Bson filter;

        ElemMatchFilterProjection(String fieldName, Bson filter) {
            this.fieldName = fieldName;
            this.filter = filter;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.fieldName, (BsonValue)new BsonDocument("$elemMatch", (BsonValue)this.filter.toBsonDocument(documentClass, codecRegistry)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElemMatchFilterProjection that = (ElemMatchFilterProjection)o;
            if (!Objects.equals(this.fieldName, that.fieldName)) {
                return false;
            }
            return Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ElemMatch Projection{fieldName='" + this.fieldName + '\'' + ", filter=" + this.filter + '}';
        }
    }

    private static class FieldsProjection
    implements Bson {
        private final List<? extends Bson> projections;

        FieldsProjection(List<? extends Bson> projections) {
            this.projections = projections;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument combinedDocument = new BsonDocument();
            for (Bson bson : this.projections) {
                BsonDocument sortDocument = bson.toBsonDocument(documentClass, codecRegistry);
                for (String key : sortDocument.keySet()) {
                    combinedDocument.remove((Object)key);
                    combinedDocument.append(key, sortDocument.get((Object)key));
                }
            }
            return combinedDocument;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldsProjection that = (FieldsProjection)o;
            return Objects.equals(this.projections, that.projections);
        }

        public int hashCode() {
            return this.projections != null ? this.projections.hashCode() : 0;
        }

        public String toString() {
            return "Projections{projections=" + this.projections + '}';
        }
    }
}

