/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoConfigurationException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.internal.connection.BaseCluster;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.ClusterableServerFactory;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleServerCluster
extends BaseCluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final AtomicReference<ClusterableServer> server;

    public SingleServerCluster(ClusterId clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory) {
        super(clusterId, settings, serverFactory);
        Assertions.isTrue("one server in a direct cluster", settings.getHosts().size() == 1);
        Assertions.isTrue("connection mode is single", settings.getMode() == ClusterConnectionMode.SINGLE);
        this.server = new AtomicReference();
        this.withLock(() -> {
            this.server.set(this.createServer(settings.getHosts().get(0)));
            this.publishDescription(ServerDescription.builder().state(ServerConnectionState.CONNECTING).address(settings.getHosts().get(0)).build());
        });
    }

    @Override
    protected void connect() {
        Assertions.assertNotNull(this.server.get()).connect();
    }

    @Override
    public ClusterableServer getServer(ServerAddress serverAddress) {
        Assertions.isTrue("open", !this.isClosed());
        return Assertions.assertNotNull(this.server.get());
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            Assertions.assertNotNull(this.server.get()).close();
            super.close();
        }
    }

    @Override
    public void onChange(ServerDescriptionChangedEvent event) {
        this.withLock(() -> {
            ServerDescription newDescription = event.getNewDescription();
            if (newDescription.isOk()) {
                if (this.getSettings().getRequiredClusterType() != ClusterType.UNKNOWN && this.getSettings().getRequiredClusterType() != newDescription.getClusterType()) {
                    newDescription = null;
                } else if (this.getSettings().getRequiredClusterType() == ClusterType.REPLICA_SET && this.getSettings().getRequiredReplicaSetName() != null && !this.getSettings().getRequiredReplicaSetName().equals(newDescription.getSetName())) {
                    newDescription = ServerDescription.builder(newDescription).exception(new MongoConfigurationException(String.format("Replica set name '%s' does not match required replica set name of '%s'", newDescription.getSetName(), this.getSettings().getRequiredReplicaSetName()))).type(ServerType.UNKNOWN).setName(null).ok(false).build();
                    this.publishDescription(ClusterType.UNKNOWN, newDescription);
                    return;
                }
            }
            this.publishDescription(newDescription);
        });
    }

    private void publishDescription(ServerDescription serverDescription) {
        ClusterType clusterType = this.getSettings().getRequiredClusterType();
        if (clusterType == ClusterType.UNKNOWN && serverDescription != null) {
            clusterType = serverDescription.getClusterType();
        }
        this.publishDescription(clusterType, serverDescription);
    }

    private void publishDescription(ClusterType clusterType, ServerDescription serverDescription) {
        ClusterDescription currentDescription = this.getCurrentDescription();
        ClusterDescription description = new ClusterDescription(ClusterConnectionMode.SINGLE, clusterType, serverDescription == null ? Collections.emptyList() : Collections.singletonList(serverDescription), this.getSettings(), this.getServerFactory().getSettings());
        this.updateDescription(description);
        this.fireChangeEvent(description, currentDescription);
    }
}

