/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.Function;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import java.util.ArrayList;
import java.util.List;

class MappingAsyncBatchCursor<T, U>
implements AsyncBatchCursor<U> {
    private final AsyncBatchCursor<T> batchCursor;
    private final Function<T, U> mapper;

    MappingAsyncBatchCursor(AsyncBatchCursor<T> batchCursor, Function<T, U> mapper) {
        this.batchCursor = batchCursor;
        this.mapper = mapper;
    }

    @Override
    public void next(SingleResultCallback<List<U>> callback) {
        this.batchCursor.next(this.getMappingCallback(callback));
    }

    @Override
    public void tryNext(SingleResultCallback<List<U>> callback) {
        this.batchCursor.tryNext(this.getMappingCallback(callback));
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchCursor.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.batchCursor.getBatchSize();
    }

    @Override
    public boolean isClosed() {
        return this.batchCursor.isClosed();
    }

    @Override
    public void close() {
        this.batchCursor.close();
    }

    private SingleResultCallback<List<T>> getMappingCallback(final SingleResultCallback<List<U>> callback) {
        return new SingleResultCallback<List<T>>(){

            @Override
            public void onResult(List<T> results, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (results != null) {
                    try {
                        ArrayList mappedResults = new ArrayList();
                        for (Object result : results) {
                            mappedResults.add(MappingAsyncBatchCursor.this.mapper.apply(result));
                        }
                        callback.onResult(mappedResults, null);
                    }
                    catch (Throwable t1) {
                        callback.onResult(null, t1);
                    }
                } else {
                    callback.onResult(null, null);
                }
            }
        };
    }
}

