/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncAggregateIterable;
import com.mongodb.internal.async.client.AsyncChangeStreamIterable;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncListCollectionsIterable;
import com.mongodb.internal.async.client.AsyncMongoCollection;
import com.mongodb.internal.async.client.AsyncMongoIterable;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@ThreadSafe
public interface AsyncMongoDatabase {
    public String getName();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public AsyncMongoDatabase withCodecRegistry(CodecRegistry var1);

    public AsyncMongoDatabase withReadPreference(ReadPreference var1);

    public AsyncMongoDatabase withWriteConcern(WriteConcern var1);

    public AsyncMongoDatabase withReadConcern(ReadConcern var1);

    public AsyncMongoCollection<Document> getCollection(String var1);

    public <TDocument> AsyncMongoCollection<TDocument> getCollection(String var1, Class<TDocument> var2);

    public void runCommand(Bson var1, SingleResultCallback<Document> var2);

    public void runCommand(Bson var1, ReadPreference var2, SingleResultCallback<Document> var3);

    public <TResult> void runCommand(Bson var1, Class<TResult> var2, SingleResultCallback<TResult> var3);

    public <TResult> void runCommand(Bson var1, ReadPreference var2, Class<TResult> var3, SingleResultCallback<TResult> var4);

    public void runCommand(AsyncClientSession var1, Bson var2, SingleResultCallback<Document> var3);

    public void runCommand(AsyncClientSession var1, Bson var2, ReadPreference var3, SingleResultCallback<Document> var4);

    public <TResult> void runCommand(AsyncClientSession var1, Bson var2, Class<TResult> var3, SingleResultCallback<TResult> var4);

    public <TResult> void runCommand(AsyncClientSession var1, Bson var2, ReadPreference var3, Class<TResult> var4, SingleResultCallback<TResult> var5);

    public void drop(SingleResultCallback<Void> var1);

    public void drop(AsyncClientSession var1, SingleResultCallback<Void> var2);

    public AsyncMongoIterable<String> listCollectionNames();

    public AsyncMongoIterable<String> listCollectionNames(AsyncClientSession var1);

    public AsyncListCollectionsIterable<Document> listCollections();

    public <TResult> AsyncListCollectionsIterable<TResult> listCollections(Class<TResult> var1);

    public AsyncListCollectionsIterable<Document> listCollections(AsyncClientSession var1);

    public <TResult> AsyncListCollectionsIterable<TResult> listCollections(AsyncClientSession var1, Class<TResult> var2);

    public void createCollection(String var1, SingleResultCallback<Void> var2);

    public void createCollection(String var1, CreateCollectionOptions var2, SingleResultCallback<Void> var3);

    public void createCollection(AsyncClientSession var1, String var2, SingleResultCallback<Void> var3);

    public void createCollection(AsyncClientSession var1, String var2, CreateCollectionOptions var3, SingleResultCallback<Void> var4);

    public void createView(String var1, String var2, List<? extends Bson> var3, SingleResultCallback<Void> var4);

    public void createView(String var1, String var2, List<? extends Bson> var3, CreateViewOptions var4, SingleResultCallback<Void> var5);

    public void createView(AsyncClientSession var1, String var2, String var3, List<? extends Bson> var4, SingleResultCallback<Void> var5);

    public void createView(AsyncClientSession var1, String var2, String var3, List<? extends Bson> var4, CreateViewOptions var5, SingleResultCallback<Void> var6);

    public AsyncChangeStreamIterable<Document> watch();

    public <TResult> AsyncChangeStreamIterable<TResult> watch(Class<TResult> var1);

    public AsyncChangeStreamIterable<Document> watch(List<? extends Bson> var1);

    public <TResult> AsyncChangeStreamIterable<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public AsyncChangeStreamIterable<Document> watch(AsyncClientSession var1);

    public <TResult> AsyncChangeStreamIterable<TResult> watch(AsyncClientSession var1, Class<TResult> var2);

    public AsyncChangeStreamIterable<Document> watch(AsyncClientSession var1, List<? extends Bson> var2);

    public <TResult> AsyncChangeStreamIterable<TResult> watch(AsyncClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public AsyncAggregateIterable<Document> aggregate(List<? extends Bson> var1);

    public <TResult> AsyncAggregateIterable<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public AsyncAggregateIterable<Document> aggregate(AsyncClientSession var1, List<? extends Bson> var2);

    public <TResult> AsyncAggregateIterable<TResult> aggregate(AsyncClientSession var1, List<? extends Bson> var2, Class<TResult> var3);
}

