/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.MongoInternalException;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsynchronousSocketChannelStreamFactoryFactory;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.TlsChannelStreamFactoryFactory;
import com.mongodb.internal.async.client.AsyncMongoClient;
import com.mongodb.internal.async.client.AsyncMongoClientImpl;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.DefaultClusterFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import org.bson.codecs.configuration.CodecRegistry;

public final class AsyncMongoClients {
    public static AsyncMongoClient create() {
        return AsyncMongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static AsyncMongoClient create(String connectionString) {
        return AsyncMongoClients.create(new ConnectionString(connectionString));
    }

    public static AsyncMongoClient create(ConnectionString connectionString) {
        return AsyncMongoClients.create(connectionString, null);
    }

    public static AsyncMongoClient create(ConnectionString connectionString, @Nullable MongoDriverInformation mongoDriverInformation) {
        return AsyncMongoClients.create(MongoClientSettings.builder().applyConnectionString(connectionString).build(), mongoDriverInformation);
    }

    public static AsyncMongoClient create(MongoClientSettings settings) {
        return AsyncMongoClients.create(settings, null);
    }

    public static AsyncMongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        if (settings.getStreamFactoryFactory() == null) {
            if (settings.getSslSettings().isEnabled()) {
                return AsyncMongoClients.createWithTlsChannel(settings, mongoDriverInformation);
            }
            return AsyncMongoClients.createWithAsynchronousSocketChannel(settings, mongoDriverInformation);
        }
        return AsyncMongoClients.createMongoClient(settings, mongoDriverInformation, AsyncMongoClients.getStreamFactory(settings, false), AsyncMongoClients.getStreamFactory(settings, true), null);
    }

    private static AsyncMongoClient createMongoClient(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable Closeable externalResourceCloser) {
        return new AsyncMongoClientImpl(settings, AsyncMongoClients.createCluster(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory), externalResourceCloser);
    }

    private static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory) {
        Assertions.notNull("settings", settings);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), streamFactory, heartbeatStreamFactory, settings.getCredential(), EventListenerHelper.getCommandListener(settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList());
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return MongoClientSettings.getDefaultCodecRegistry();
    }

    private static AsyncMongoClient createWithTlsChannel(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        final TlsChannelStreamFactoryFactory streamFactoryFactory = new TlsChannelStreamFactoryFactory();
        StreamFactory streamFactory = streamFactoryFactory.create(settings.getSocketSettings(), settings.getSslSettings());
        StreamFactory heartbeatStreamFactory = streamFactoryFactory.create(settings.getHeartbeatSocketSettings(), settings.getSslSettings());
        return AsyncMongoClients.createMongoClient(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory, new Closeable(){

            @Override
            public void close() {
                streamFactoryFactory.close();
            }
        });
    }

    private static AsyncMongoClient createWithAsynchronousSocketChannel(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        AsynchronousSocketChannelStreamFactoryFactory streamFactoryFactory = AsynchronousSocketChannelStreamFactoryFactory.builder().build();
        StreamFactory streamFactory = streamFactoryFactory.create(settings.getSocketSettings(), settings.getSslSettings());
        StreamFactory heartbeatStreamFactory = streamFactoryFactory.create(settings.getHeartbeatSocketSettings(), settings.getSslSettings());
        return AsyncMongoClients.createMongoClient(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory, null);
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings, boolean isHeartbeat) {
        StreamFactoryFactory streamFactoryFactory = settings.getStreamFactoryFactory();
        if (streamFactoryFactory == null) {
            throw new MongoInternalException("should not happen");
        }
        return streamFactoryFactory.create(isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings(), settings.getSslSettings());
    }

    private AsyncMongoClients() {
    }
}

