/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import org.bson.BsonBinary;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDbPointer;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

abstract class LevelCountingBsonWriter
implements BsonWriter {
    private final BsonBinaryWriter bsonBinaryWriter;
    private int level = -1;

    LevelCountingBsonWriter(BsonBinaryWriter bsonBinaryWriter) {
        this.bsonBinaryWriter = (BsonBinaryWriter)Assertions.notNull((String)"bsonBinaryWriter", (Object)bsonBinaryWriter);
    }

    public int getCurrentLevel() {
        return this.level;
    }

    public BsonBinaryWriter getBsonBinaryWriter() {
        return this.bsonBinaryWriter;
    }

    public void writeStartDocument(String name) {
        ++this.level;
        this.bsonBinaryWriter.writeStartDocument(name);
    }

    public void writeStartDocument() {
        ++this.level;
        this.bsonBinaryWriter.writeStartDocument();
    }

    public void writeEndDocument() {
        --this.level;
        this.bsonBinaryWriter.writeEndDocument();
    }

    public void writeStartArray(String name) {
        this.bsonBinaryWriter.writeStartArray(name);
    }

    public void writeStartArray() {
        this.bsonBinaryWriter.writeStartArray();
    }

    public void writeEndArray() {
        this.bsonBinaryWriter.writeEndArray();
    }

    public void writeBinaryData(String name, BsonBinary binary) {
        this.bsonBinaryWriter.writeBinaryData(name, binary);
    }

    public void writeBinaryData(BsonBinary binary) {
        this.bsonBinaryWriter.writeBinaryData(binary);
    }

    public void writeBoolean(String name, boolean value) {
        this.bsonBinaryWriter.writeBoolean(name, value);
    }

    public void writeBoolean(boolean value) {
        this.bsonBinaryWriter.writeBoolean(value);
    }

    public void writeDateTime(String name, long value) {
        this.bsonBinaryWriter.writeDateTime(name, value);
    }

    public void writeDateTime(long value) {
        this.bsonBinaryWriter.writeDateTime(value);
    }

    public void writeDBPointer(String name, BsonDbPointer value) {
        this.bsonBinaryWriter.writeDBPointer(name, value);
    }

    public void writeDBPointer(BsonDbPointer value) {
        this.bsonBinaryWriter.writeDBPointer(value);
    }

    public void writeDouble(String name, double value) {
        this.bsonBinaryWriter.writeDouble(name, value);
    }

    public void writeDouble(double value) {
        this.bsonBinaryWriter.writeDouble(value);
    }

    public void writeInt32(String name, int value) {
        this.bsonBinaryWriter.writeInt32(name, value);
    }

    public void writeInt32(int value) {
        this.bsonBinaryWriter.writeInt32(value);
    }

    public void writeInt64(String name, long value) {
        this.bsonBinaryWriter.writeInt64(name, value);
    }

    public void writeInt64(long value) {
        this.bsonBinaryWriter.writeInt64(value);
    }

    public void writeDecimal128(Decimal128 value) {
        this.bsonBinaryWriter.writeDecimal128(value);
    }

    public void writeDecimal128(String name, Decimal128 value) {
        this.bsonBinaryWriter.writeDecimal128(name, value);
    }

    public void writeJavaScript(String name, String code) {
        this.bsonBinaryWriter.writeJavaScript(name, code);
    }

    public void writeJavaScript(String code) {
        this.bsonBinaryWriter.writeJavaScript(code);
    }

    public void writeJavaScriptWithScope(String name, String code) {
        this.bsonBinaryWriter.writeJavaScriptWithScope(name, code);
    }

    public void writeJavaScriptWithScope(String code) {
        this.bsonBinaryWriter.writeJavaScriptWithScope(code);
    }

    public void writeMaxKey(String name) {
        this.bsonBinaryWriter.writeMaxKey(name);
    }

    public void writeMaxKey() {
        this.bsonBinaryWriter.writeMaxKey();
    }

    public void writeMinKey(String name) {
        this.bsonBinaryWriter.writeMinKey(name);
    }

    public void writeMinKey() {
        this.bsonBinaryWriter.writeMinKey();
    }

    public void writeName(String name) {
        this.bsonBinaryWriter.writeName(name);
    }

    public void writeNull(String name) {
        this.bsonBinaryWriter.writeNull(name);
    }

    public void writeNull() {
        this.bsonBinaryWriter.writeNull();
    }

    public void writeObjectId(String name, ObjectId objectId) {
        this.bsonBinaryWriter.writeObjectId(name, objectId);
    }

    public void writeObjectId(ObjectId objectId) {
        this.bsonBinaryWriter.writeObjectId(objectId);
    }

    public void writeRegularExpression(String name, BsonRegularExpression regularExpression) {
        this.bsonBinaryWriter.writeRegularExpression(name, regularExpression);
    }

    public void writeRegularExpression(BsonRegularExpression regularExpression) {
        this.bsonBinaryWriter.writeRegularExpression(regularExpression);
    }

    public void writeString(String name, String value) {
        this.bsonBinaryWriter.writeString(name, value);
    }

    public void writeString(String value) {
        this.bsonBinaryWriter.writeString(value);
    }

    public void writeSymbol(String name, String value) {
        this.bsonBinaryWriter.writeSymbol(name, value);
    }

    public void writeSymbol(String value) {
        this.bsonBinaryWriter.writeSymbol(value);
    }

    public void writeTimestamp(String name, BsonTimestamp value) {
        this.bsonBinaryWriter.writeTimestamp(name, value);
    }

    public void writeTimestamp(BsonTimestamp value) {
        this.bsonBinaryWriter.writeTimestamp(value);
    }

    public void writeUndefined(String name) {
        this.bsonBinaryWriter.writeUndefined(name);
    }

    public void writeUndefined() {
        this.bsonBinaryWriter.writeUndefined();
    }

    public void pipe(BsonReader reader) {
        this.bsonBinaryWriter.pipe(reader);
    }

    public void flush() {
        this.bsonBinaryWriter.flush();
    }
}

