/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoWriteConcernException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.OperationHelper;
import org.bson.BsonDocument;
import org.bson.BsonValue;

final class WriteConcernHelper {
    static void appendWriteConcernToCommand(WriteConcern writeConcern, BsonDocument commandDocument, ConnectionDescription description) {
        if (writeConcern != null && !writeConcern.isServerDefault() && OperationHelper.serverIsAtLeastVersionThreeDotFour(description)) {
            commandDocument.put("writeConcern", (BsonValue)writeConcern.asDocument());
        }
    }

    static CommandOperationHelper.CommandTransformer<BsonDocument, Void> writeConcernErrorTransformer() {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, Void>(){

            @Override
            public Void apply(BsonDocument result, ServerAddress serverAddress) {
                WriteConcernHelper.throwOnWriteConcernError(result, serverAddress);
                return null;
            }
        };
    }

    static void throwOnWriteConcernError(BsonDocument result, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(result)) {
            throw WriteConcernHelper.createWriteConcernError(result, serverAddress);
        }
    }

    static boolean hasWriteConcernError(BsonDocument result) {
        return result.containsKey((Object)"writeConcernError");
    }

    static MongoWriteConcernException createWriteConcernError(BsonDocument result, ServerAddress serverAddress) {
        return new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result.getDocument((Object)"writeConcernError")), WriteConcernResult.acknowledged(0, false, null), serverAddress);
    }

    static WriteConcernError createWriteConcernError(BsonDocument writeConcernErrorDocument) {
        return new WriteConcernError(writeConcernErrorDocument.getNumber((Object)"code").intValue(), writeConcernErrorDocument.getString((Object)"errmsg").getValue(), writeConcernErrorDocument.getDocument((Object)"errInfo", new BsonDocument()));
    }

    private WriteConcernHelper() {
    }
}

