/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ClientSessionOptions;
import com.mongodb.TransactionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.ClientSessionImpl;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.OperationExecutor;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.Server;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;
import java.util.List;

class ClientSessionHelper {
    private final MongoClientImpl mongoClient;
    private final ServerSessionPool serverSessionPool;

    ClientSessionHelper(MongoClientImpl mongoClient, ServerSessionPool serverSessionPool) {
        this.mongoClient = mongoClient;
        this.serverSessionPool = serverSessionPool;
    }

    void withClientSession(@Nullable ClientSession clientSessionFromOperation, OperationExecutor executor, SingleResultCallback<ClientSession> callback) {
        if (clientSessionFromOperation != null) {
            Assertions.isTrue((String)"ClientSession from same MongoClient", (clientSessionFromOperation.getOriginator() == this.mongoClient ? 1 : 0) != 0);
            callback.onResult((Object)clientSessionFromOperation, null);
        } else {
            this.createClientSession(ClientSessionOptions.builder().causallyConsistent(false).build(), executor, callback);
        }
    }

    void createClientSession(final ClientSessionOptions options, final OperationExecutor executor, final SingleResultCallback<ClientSession> callback) {
        if (this.mongoClient.getSettings().getCredentialList().size() > 1) {
            callback.onResult(null, null);
        } else {
            ClusterDescription clusterDescription = this.mongoClient.getCluster().getCurrentDescription();
            if (!this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription).isEmpty() && clusterDescription.getLogicalSessionTimeoutMinutes() != null && clusterDescription.getType() != ClusterType.STANDALONE) {
                callback.onResult((Object)this.createClientSession(options, executor), null);
            } else {
                this.mongoClient.getCluster().selectServerAsync(new ServerSelector(){

                    public List<ServerDescription> select(ClusterDescription clusterDescription) {
                        return ClientSessionHelper.this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription);
                    }
                }, (SingleResultCallback)new SingleResultCallback<Server>(){

                    public void onResult(Server server, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, null);
                        } else if (server.getDescription().getLogicalSessionTimeoutMinutes() == null || server.getDescription().getType() == ServerType.STANDALONE) {
                            callback.onResult(null, null);
                        } else {
                            callback.onResult((Object)ClientSessionHelper.this.createClientSession(options, executor), null);
                        }
                    }
                });
            }
        }
    }

    private ClientSession createClientSession(ClientSessionOptions options, OperationExecutor executor) {
        ClientSessionOptions mergedOptions = ClientSessionOptions.builder((ClientSessionOptions)options).defaultTransactionOptions(TransactionOptions.merge((TransactionOptions)options.getDefaultTransactionOptions(), (TransactionOptions)TransactionOptions.builder().readConcern(this.mongoClient.getSettings().getReadConcern()).writeConcern(this.mongoClient.getSettings().getWriteConcern()).readPreference(this.mongoClient.getSettings().getReadPreference()).build())).build();
        return new ClientSessionImpl(this.serverSessionPool, this.mongoClient, mergedOptions, executor);
    }

    private List<ServerDescription> getServerDescriptionListToConsiderForSessionSupport(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return clusterDescription.getAny();
        }
        return clusterDescription.getAnyPrimaryOrSecondary();
    }
}

