/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.DoesNothing;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.internal.stubbing.answers.ThrowsExceptionClass;
import org.mockito.internal.util.MockUtil;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;

public class StubberImpl
implements Stubber {
    private final List<Answer<?>> answers = new LinkedList();

    @Override
    public <T> T when(T mock) {
        if (mock == null) {
            throw Reporter.nullPassedToWhenMethod();
        }
        if (!MockUtil.isMock(mock)) {
            throw Reporter.notAMockPassedToWhenMethod();
        }
        MockUtil.getMockHandler(mock).setAnswersForStubbing(this.answers);
        return mock;
    }

    @Override
    public Stubber doReturn(Object toBeReturned) {
        return this.doReturnValues(toBeReturned);
    }

    @Override
    public Stubber doReturn(Object toBeReturned, Object ... nextToBeReturned) {
        return this.doReturnValues(toBeReturned).doReturnValues(nextToBeReturned);
    }

    private StubberImpl doReturnValues(Object ... toBeReturned) {
        if (toBeReturned == null) {
            this.answers.add(new Returns(null));
            return this;
        }
        for (Object r : toBeReturned) {
            this.answers.add(new Returns(r));
        }
        return this;
    }

    @Override
    public Stubber doThrow(Throwable ... toBeThrown) {
        if (toBeThrown == null) {
            this.answers.add(new ThrowsException(null));
            return this;
        }
        for (Throwable throwable : toBeThrown) {
            this.answers.add(new ThrowsException(throwable));
        }
        return this;
    }

    @Override
    public Stubber doThrow(Class<? extends Throwable> toBeThrown) {
        return this.doThrowClasses(toBeThrown);
    }

    @Override
    public Stubber doThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... nextToBeThrown) {
        return this.doThrowClasses(toBeThrown).doThrowClasses(nextToBeThrown);
    }

    private StubberImpl doThrowClasses(Class<? extends Throwable> ... toBeThrown) {
        for (Class<? extends Throwable> throwable : toBeThrown) {
            this.answers.add(new ThrowsExceptionClass(throwable));
        }
        return this;
    }

    @Override
    public Stubber doNothing() {
        this.answers.add(new DoesNothing());
        return this;
    }

    @Override
    public Stubber doAnswer(Answer answer) {
        this.answers.add(answer);
        return this;
    }

    @Override
    public Stubber doCallRealMethod() {
        this.answers.add(new CallsRealMethods());
        return this;
    }
}

