/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.mockito.internal.debugging.LocationImpl;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.exceptions.VerificationAwareInvocation;
import org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;
import org.mockito.internal.invocation.ArgumentsProcessor;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.StubInfo;

class InterceptedInvocation
implements Invocation,
VerificationAwareInvocation {
    private static final long serialVersionUID = 475027563923510472L;
    private final Object mock;
    private final MockitoMethod mockitoMethod;
    private final Object[] arguments;
    private final Object[] rawArguments;
    private final SuperMethod superMethod;
    private final int sequenceNumber;
    private final Location location;
    private boolean verified;
    private boolean isIgnoredForVerification;
    private StubInfo stubInfo;

    public InterceptedInvocation(Object mock, MockitoMethod mockitoMethod, Object[] arguments, SuperMethod superMethod, int sequenceNumber) {
        this.mock = mock;
        this.mockitoMethod = mockitoMethod;
        this.arguments = ArgumentsProcessor.expandVarArgs(mockitoMethod.isVarArgs(), arguments);
        this.rawArguments = arguments;
        this.superMethod = superMethod;
        this.sequenceNumber = sequenceNumber;
        this.location = new LocationImpl();
    }

    @Override
    public boolean isVerified() {
        return this.verified || this.isIgnoredForVerification;
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Object[] getRawArguments() {
        return this.rawArguments;
    }

    @Override
    public Class<?> getRawReturnType() {
        return this.mockitoMethod.getReturnType();
    }

    @Override
    public void markVerified() {
        this.verified = true;
    }

    @Override
    public StubInfo stubInfo() {
        return this.stubInfo;
    }

    @Override
    public void markStubbed(StubInfo stubInfo) {
        this.stubInfo = stubInfo;
    }

    @Override
    public boolean isIgnoredForVerification() {
        return this.isIgnoredForVerification;
    }

    @Override
    public void ignoreForVerification() {
        this.isIgnoredForVerification = true;
    }

    @Override
    public Object getMock() {
        return this.mock;
    }

    @Override
    public Method getMethod() {
        return this.mockitoMethod.getJavaMethod();
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public <T> T getArgument(int index) {
        return (T)this.arguments[index];
    }

    @Override
    public Object callRealMethod() throws Throwable {
        if (!this.superMethod.isInvokable()) {
            throw Reporter.cannotCallAbstractRealMethod();
        }
        return this.superMethod.invoke();
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        InterceptedInvocation other = (InterceptedInvocation)o;
        return this.mock.equals(other.mock) && this.mockitoMethod.equals(other.mockitoMethod) && this.equalArguments(other.arguments);
    }

    private boolean equalArguments(Object[] arguments) {
        return Arrays.equals(arguments, this.arguments);
    }

    @Override
    public String toString() {
        return new PrintSettings().print(ArgumentsProcessor.argumentsToMatchers(this.getArguments()), this);
    }

    public static interface SuperMethod
    extends Serializable {
        public boolean isInvokable();

        public Object invoke() throws Throwable;

        public static class FromCallable
        implements SuperMethod {
            private static final long serialVersionUID = 47957363950483625L;
            private final Callable<?> callable;

            public FromCallable(Callable<?> callable) {
                this.callable = callable;
            }

            @Override
            public boolean isInvokable() {
                return true;
            }

            @Override
            public Object invoke() throws Throwable {
                try {
                    return this.callable.call();
                }
                catch (Throwable t) {
                    new ConditionalStackTraceFilter().filter(t);
                    throw t;
                }
            }
        }

        public static enum IsIllegal implements SuperMethod
        {
            INSTANCE;


            @Override
            public boolean isInvokable() {
                return false;
            }

            @Override
            public Object invoke() {
                throw new IllegalStateException();
            }
        }
    }
}

