/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.RandomString;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.mockito.internal.creation.bytebuddy.MockMethodAdvice;
import org.mockito.internal.creation.bytebuddy.MockMethodDispatcher;
import org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.mockito.internal.creation.bytebuddy.SubclassBytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.TypeCachingBytecodeGenerator;
import org.mockito.internal.util.StringUtil;
import org.mockito.internal.util.concurrent.WeakConcurrentMap;
import org.mockito.internal.util.concurrent.WeakConcurrentSet;
import org.mockito.mock.SerializableMode;

public class InlineBytecodeGenerator
implements BytecodeGenerator,
ClassFileTransformer {
    static final Set<Class<?>> EXCLUDES = new HashSet<Class>(Arrays.asList(Class.class, Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class));
    private final Instrumentation instrumentation;
    private final ByteBuddy byteBuddy;
    private final WeakConcurrentSet<Class<?>> mocked;
    private final String identifier;
    private final MockMethodAdvice advice;
    private final BytecodeGenerator subclassEngine;
    private volatile Throwable lastException;

    public InlineBytecodeGenerator(Instrumentation instrumentation, WeakConcurrentMap<Object, MockMethodInterceptor> mocks) {
        this.instrumentation = instrumentation;
        this.byteBuddy = new ByteBuddy().with(TypeValidation.DISABLED).with((Implementation.Context.Factory)Implementation.Context.Disabled.Factory.INSTANCE).with((MethodGraph.Compiler)MethodGraph.Compiler.ForDeclaredMethods.INSTANCE);
        this.mocked = new WeakConcurrentSet(WeakConcurrentSet.Cleaner.INLINE);
        this.identifier = RandomString.make();
        this.advice = new MockMethodAdvice(mocks, this.identifier);
        this.subclassEngine = new TypeCachingBytecodeGenerator(new SubclassBytecodeGenerator((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{TargetMethodAnnotationDrivenBinder.ParameterBinder.ForFixedValue.OfConstant.of(MockMethodAdvice.Identifier.class, (Object)this.identifier)}).to(MockMethodAdvice.ForReadObject.class), (ElementMatcher<? super MethodDescription>)ElementMatchers.isAbstract().or((ElementMatcher)ElementMatchers.isNative()).or((ElementMatcher)ElementMatchers.isToString())), false);
        MockMethodDispatcher.set((String)this.identifier, (MockMethodDispatcher)this.advice);
        instrumentation.addTransformer(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Class<? extends T> mockClass(MockFeatures<T> features) {
        boolean subclassingRequired = !features.interfaces.isEmpty() || features.serializableMode != SerializableMode.NONE || Modifier.isAbstract(features.mockedType.getModifiers());
        this.checkSupportedCombination(subclassingRequired, features);
        InlineBytecodeGenerator inlineBytecodeGenerator = this;
        synchronized (inlineBytecodeGenerator) {
            this.triggerRetransformation(features);
        }
        return subclassingRequired ? this.subclassEngine.mockClass(features) : features.mockedType;
    }

    private <T> void triggerRetransformation(MockFeatures<T> features) {
        HashSet types = new HashSet();
        Class type = features.mockedType;
        do {
            if (!this.mocked.add(type)) continue;
            types.add(type);
            this.addInterfaces(types, type.getInterfaces());
        } while ((type = type.getSuperclass()) != null);
        if (!types.isEmpty()) {
            try {
                this.instrumentation.retransformClasses(types.toArray(new Class[types.size()]));
                Throwable throwable = this.lastException;
                if (throwable != null) {
                    throw new IllegalStateException(StringUtil.join("Byte Buddy could not instrument all classes within the mock's type hierarchy", "", "This problem should never occur for javac-compiled classes. This problem has been observed for classes that are:", " - Compiled by older versions of scalac", " - Classes that are part of the Android distribution"), throwable);
                }
            }
            catch (Exception exception) {
                for (Class clazz : types) {
                    this.mocked.remove(clazz);
                }
                throw new MockitoException("Could not modify all classes " + types, exception);
            }
            finally {
                this.lastException = null;
            }
        }
    }

    private <T> void checkSupportedCombination(boolean subclassingRequired, MockFeatures<T> features) {
        if (subclassingRequired && !features.mockedType.isArray() && !features.mockedType.isPrimitive() && Modifier.isFinal(features.mockedType.getModifiers())) {
            throw new MockitoException("Unsupported settings with this type '" + features.mockedType.getName() + "'");
        }
    }

    private void addInterfaces(Set<Class<?>> types, Class<?>[] interfaces) {
        for (Class<?> type : interfaces) {
            if (!this.mocked.add(type)) continue;
            types.add(type);
            this.addInterfaces(types, type.getInterfaces());
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (classBeingRedefined == null || !this.mocked.contains(classBeingRedefined) || EXCLUDES.contains(classBeingRedefined)) {
            return null;
        }
        try {
            return this.byteBuddy.redefine(classBeingRedefined, ClassFileLocator.Simple.of((String)classBeingRedefined.getName(), (byte[])classfileBuffer)).visit((AsmVisitorWrapper)new ParameterWritingVisitorWrapper(classBeingRedefined)).visit((AsmVisitorWrapper)Advice.withCustomMapping().bind(MockMethodAdvice.Identifier.class, (Object)this.identifier).to(MockMethodAdvice.class).on((ElementMatcher)ElementMatchers.isVirtual().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isBridge().or((ElementMatcher)ElementMatchers.isHashCode()).or((ElementMatcher)ElementMatchers.isEquals()).or((ElementMatcher)ElementMatchers.isDefaultFinalizer()))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDeclaredBy((ElementMatcher)ElementMatchers.nameStartsWith((String)"java.")).and((ElementMatcher)ElementMatchers.isPackagePrivate()))))).visit((AsmVisitorWrapper)Advice.withCustomMapping().bind(MockMethodAdvice.Identifier.class, (Object)this.identifier).to(MockMethodAdvice.ForHashCode.class).on((ElementMatcher)ElementMatchers.isHashCode())).visit((AsmVisitorWrapper)Advice.withCustomMapping().bind(MockMethodAdvice.Identifier.class, (Object)this.identifier).to(MockMethodAdvice.ForEquals.class).on((ElementMatcher)ElementMatchers.isEquals())).make().getBytes();
        }
        catch (Throwable throwable) {
            this.lastException = throwable;
            return null;
        }
    }

    private static class ParameterWritingVisitorWrapper
    extends AsmVisitorWrapper.AbstractBase {
        private final Class<?> type;

        private ParameterWritingVisitorWrapper(Class<?> type) {
            this.type = type;
        }

        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
            return implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V8) ? new ParameterAddingClassVisitor(classVisitor, (TypeDescription)new TypeDescription.ForLoadedType(this.type)) : classVisitor;
        }

        private static class MethodParameterStrippingMethodVisitor
        extends MethodVisitor {
            public MethodParameterStrippingMethodVisitor(MethodVisitor mv) {
                super(327680, mv);
            }

            public void visitParameter(String name, int access) {
            }
        }

        private static class ParameterAddingClassVisitor
        extends ClassVisitor {
            private final TypeDescription typeDescription;

            private ParameterAddingClassVisitor(ClassVisitor cv, TypeDescription typeDescription) {
                super(327680, cv);
                this.typeDescription = typeDescription;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
                MethodList methodList = (MethodList)this.typeDescription.getDeclaredMethods().filter((ElementMatcher)(name.equals("<init>") ? ElementMatchers.isConstructor() : ElementMatchers.named((String)name)).and((ElementMatcher)ElementMatchers.hasDescriptor((String)desc)));
                if (methodList.size() == 1 && ((MethodDescription)methodList.getOnly()).getParameters().hasExplicitMetaData()) {
                    for (ParameterDescription parameterDescription : ((MethodDescription)methodList.getOnly()).getParameters()) {
                        methodVisitor.visitParameter(parameterDescription.getName(), parameterDescription.getModifiers());
                    }
                    return new MethodParameterStrippingMethodVisitor(methodVisitor);
                }
                return methodVisitor;
            }
        }
    }
}

