/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.stub.command;

import java.net.UnknownHostException;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.command.InvocationRecord;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.HostAndPort;
import org.mockftpserver.core.util.PortParser;
import org.mockftpserver.stub.command.AbstractStubCommandHandler;

public class EprtCommandHandler
extends AbstractStubCommandHandler
implements CommandHandler {
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";

    public EprtCommandHandler() {
        this.setReplyCode(200);
    }

    @Override
    public void handleCommand(Command command, Session session, InvocationRecord invocationRecord) throws UnknownHostException {
        String parameter = command.getRequiredParameter(0);
        HostAndPort client = PortParser.parseExtendedAddressHostAndPort(parameter);
        this.LOG.debug("host=" + client.host + " port=" + client.port);
        session.setClientDataHost(client.host);
        session.setClientDataPort(client.port);
        invocationRecord.set(HOST_KEY, client.host);
        invocationRecord.set(PORT_KEY, new Integer(client.port));
        this.sendReply(session);
    }
}

