/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.core.command;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.command.ReplyTextBundleAware;
import org.mockftpserver.core.command.ReplyTextBundleUtil;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.Assert;

public final class SimpleCompositeCommandHandler
implements CommandHandler,
ReplyTextBundleAware {
    private List commandHandlers = new ArrayList();
    private int invocationIndex = 0;

    public void addCommandHandler(CommandHandler commandHandler) {
        Assert.notNull(commandHandler, "commandHandler");
        this.commandHandlers.add(commandHandler);
    }

    public void setCommandHandlers(List commandHandlers) {
        Assert.notNull(commandHandlers, "commandHandlers");
        this.commandHandlers = new ArrayList(commandHandlers);
    }

    public CommandHandler getCommandHandler(int index) {
        Assert.isTrue(index < this.commandHandlers.size(), "No CommandHandler defined for index " + index);
        Assert.isTrue(index >= 0, "The index cannot be less than zero: " + index);
        return (CommandHandler)this.commandHandlers.get(index);
    }

    @Override
    public void handleCommand(Command command, Session session) throws Exception {
        Assert.notNull(command, "command");
        Assert.notNull(session, "session");
        Assert.isTrue(this.commandHandlers.size() > this.invocationIndex, "No CommandHandler defined for invocation #" + this.invocationIndex);
        CommandHandler commandHandler = (CommandHandler)this.commandHandlers.get(this.invocationIndex);
        ++this.invocationIndex;
        commandHandler.handleCommand(command, session);
    }

    @Override
    public ResourceBundle getReplyTextBundle() {
        return null;
    }

    @Override
    public void setReplyTextBundle(ResourceBundle replyTextBundle) {
        for (CommandHandler commandHandler : this.commandHandlers) {
            ReplyTextBundleUtil.setReplyTextBundleIfAppropriate(commandHandler, replyTextBundle);
        }
    }
}

