/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.CmdInformation;
import org.mariadb.jdbc.internal.queryresults.CmdInformationBatch;
import org.mariadb.jdbc.internal.queryresults.CmdInformationMultiple;
import org.mariadb.jdbc.internal.queryresults.CmdInformationSingle;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class Results {
    private MariaDbStatement statement;
    private int fetchSize;
    private boolean batch;
    private int expectedSize;
    private CmdInformation cmdInformation;
    private Deque<MariaSelectResultSet> executionResults;
    private MariaSelectResultSet resultSet;
    private MariaSelectResultSet callableResultSet;
    private boolean binaryFormat;
    private int resultSetScrollType;
    private int autoIncrement;

    public Results(int autoIncrement) {
        this.statement = null;
        this.fetchSize = 0;
        this.batch = false;
        this.expectedSize = 1;
        this.cmdInformation = null;
        this.binaryFormat = false;
        this.resultSetScrollType = 1003;
        this.autoIncrement = autoIncrement;
    }

    public Results(MariaDbStatement statement, int fetchSize, boolean batch, int expectedSize, boolean binaryFormat, int resultSetScrollType, int autoIncrement) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.batch = batch;
        this.expectedSize = expectedSize;
        this.cmdInformation = null;
        this.binaryFormat = binaryFormat;
        this.resultSetScrollType = resultSetScrollType;
        this.autoIncrement = autoIncrement;
    }

    public void addStats(int updateCount, long insertId, boolean moreResultAvailable) {
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(insertId, updateCount, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addSuccessStat(updateCount, insertId);
    }

    public void addStatsError(boolean moreResultAvailable) {
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(0L, -3, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addErrorStat();
    }

    public int getCurrentStatNumber() {
        return this.cmdInformation == null ? 0 : this.cmdInformation.getCurrentStatNumber();
    }

    public void addResultSet(MariaSelectResultSet resultSet, boolean moreResultAvailable) {
        if (resultSet.isCallableResult()) {
            this.callableResultSet = resultSet;
            return;
        }
        if (this.executionResults == null) {
            this.executionResults = new ArrayDeque<MariaSelectResultSet>();
        }
        this.executionResults.add(resultSet);
        if (this.cmdInformation == null) {
            if (this.batch) {
                this.cmdInformation = new CmdInformationBatch(this.expectedSize, this.autoIncrement);
            } else if (moreResultAvailable) {
                this.cmdInformation = new CmdInformationMultiple(this.expectedSize, this.autoIncrement);
            } else {
                this.cmdInformation = new CmdInformationSingle(0L, -1, this.autoIncrement);
                return;
            }
        }
        this.cmdInformation.addResultSetStat();
    }

    public CmdInformation getCmdInformation() {
        return this.cmdInformation;
    }

    public void commandEnd() {
        if (this.cmdInformation != null && this.executionResults != null && !this.cmdInformation.isCurrentUpdateCount()) {
            this.resultSet = this.executionResults.poll();
        }
    }

    public MariaSelectResultSet getResultSet() {
        return this.resultSet;
    }

    public MariaSelectResultSet getCallableResultSet() {
        return this.callableResultSet;
    }

    public void loadFully(boolean skip, Protocol protocol) throws SQLException, QueryException {
        if (this.fetchSize != 0) {
            this.fetchSize = 0;
            if (this.resultSet != null) {
                if (skip) {
                    this.resultSet.close();
                } else {
                    this.resultSet.fetchRemaining();
                }
            } else {
                MariaSelectResultSet firstResult = this.executionResults.peekFirst();
                if (firstResult != null) {
                    if (skip) {
                        firstResult.close();
                    } else {
                        firstResult.fetchRemaining();
                    }
                }
            }
        }
        if (protocol.hasMoreResults()) {
            protocol.getResult(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults(int current, Protocol protocol) throws SQLException {
        if (this.fetchSize != 0 && this.resultSet != null) {
            protocol.getLock().lock();
            try {
                if (current == 1 && this.resultSet != null) {
                    this.resultSet.close();
                } else {
                    this.resultSet.fetchRemaining();
                }
                if (protocol.hasMoreResults()) {
                    protocol.getResult(this);
                }
            }
            catch (QueryException e) {
                ExceptionMapper.throwException(e, null, this.statement);
            }
            finally {
                protocol.getLock().unlock();
            }
        }
        if (this.cmdInformation.moreResults() && !this.batch) {
            if (current == 1 && this.resultSet != null) {
                this.resultSet.close();
            }
            this.resultSet = null;
            return true;
        }
        if (current == 1 && this.resultSet != null) {
            this.resultSet.close();
        }
        if (this.executionResults != null) {
            this.resultSet = this.executionResults.poll();
        }
        return this.resultSet != null;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public MariaDbStatement getStatement() {
        return this.statement;
    }

    public boolean isBatch() {
        return this.batch;
    }

    protected void setCmdInformation(CmdInformation cmdInformation) {
        this.cmdInformation = cmdInformation;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public boolean isBinaryFormat() {
        return this.binaryFormat;
    }

    public void removeFetchSize() {
        this.fetchSize = 0;
    }

    public int getResultSetScrollType() {
        return this.resultSetScrollType;
    }

    public ResultSet getGeneratedKeys(Protocol protocol) {
        if (this.cmdInformation != null) {
            if (this.batch) {
                return this.cmdInformation.getBatchGeneratedKeys(protocol);
            }
            return this.cmdInformation.getGeneratedKeys(protocol);
        }
        return MariaSelectResultSet.createEmptyResultSet();
    }
}

