/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.processor.AnnotationBasedComponentModelProcessor;

public class JakartaComponentProcessor
extends AnnotationBasedComponentModelProcessor {
    @Override
    protected String getComponentModelIdentifier() {
        return "jakarta";
    }

    @Override
    protected List<Annotation> getTypeAnnotations(Mapper mapper) {
        if (mapper.getDecorator() == null) {
            return Arrays.asList(this.singleton(), this.named());
        }
        return Arrays.asList(this.singleton(), this.namedDelegate(mapper));
    }

    @Override
    protected List<Annotation> getDecoratorAnnotations() {
        return Arrays.asList(this.singleton(), this.named());
    }

    @Override
    protected List<Annotation> getDelegatorReferenceAnnotations(Mapper mapper) {
        return Arrays.asList(this.inject(), this.namedDelegate(mapper));
    }

    @Override
    protected List<Annotation> getMapperReferenceAnnotations() {
        return Collections.singletonList(this.inject());
    }

    @Override
    protected boolean requiresGenerationOfDecoratorClass() {
        return true;
    }

    private Annotation singleton() {
        return new Annotation(this.getTypeFactory().getType("jakarta.inject.Singleton"));
    }

    private Annotation named() {
        return new Annotation(this.getTypeFactory().getType("jakarta.inject.Named"));
    }

    private Annotation namedDelegate(Mapper mapper) {
        return new Annotation(this.getTypeFactory().getType("jakarta.inject.Named"), Collections.singletonList('\"' + mapper.getPackageName() + "." + mapper.getName() + '\"'));
    }

    private Annotation inject() {
        return new Annotation(this.getTypeFactory().getType("jakarta.inject.Inject"));
    }
}

