/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SourceMethod;

public class ParameterProvidedMethods {
    private static final ParameterProvidedMethods EMPTY = new ParameterProvidedMethods(Collections.emptyMap());
    private final Map<Parameter, List<SourceMethod>> parameterToProvidedMethods;
    private final Map<SourceMethod, Parameter> methodToProvidingParameter;

    private ParameterProvidedMethods(Map<Parameter, List<SourceMethod>> parameterToProvidedMethods) {
        this.parameterToProvidedMethods = parameterToProvidedMethods;
        this.methodToProvidingParameter = new IdentityHashMap<SourceMethod, Parameter>();
        for (Map.Entry<Parameter, List<SourceMethod>> entry : parameterToProvidedMethods.entrySet()) {
            for (SourceMethod method : entry.getValue()) {
                this.methodToProvidingParameter.put(method, entry.getKey());
            }
        }
    }

    public List<SourceMethod> getAllProvidedMethodsInParameterOrder(List<Parameter> orderedParameters) {
        ArrayList<SourceMethod> result = new ArrayList<SourceMethod>();
        for (Parameter parameter : orderedParameters) {
            List<SourceMethod> methods = this.parameterToProvidedMethods.get(parameter);
            if (methods == null) continue;
            result.addAll(methods);
        }
        return result;
    }

    public Parameter getParameterForProvidedMethod(Method method) {
        return this.methodToProvidingParameter.get(method);
    }

    public boolean isEmpty() {
        return this.methodToProvidingParameter.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ParameterProvidedMethods empty() {
        return EMPTY;
    }

    public static class Builder {
        private Map<Parameter, List<SourceMethod>> contextProvidedMethods = new HashMap<Parameter, List<SourceMethod>>();

        private Builder() {
        }

        public void addMethodsForParameter(Parameter param, List<SourceMethod> methods) {
            this.contextProvidedMethods.put(param, methods);
        }

        public ParameterProvidedMethods build() {
            return new ParameterProvidedMethods(this.contextProvidedMethods);
        }
    }
}

