/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.util.TypeUtils;

public class SelectionParameters {
    private final List<TypeMirror> qualifiers;
    private final List<String> qualifyingNames;
    private final List<TypeMirror> conditionQualifiers;
    private final List<String> conditionQualifyingNames;
    private final TypeMirror resultType;
    private final TypeUtils typeUtils;
    private final SourceRHS sourceRHS;

    public static SelectionParameters forInheritance(SelectionParameters selectionParameters) {
        return new SelectionParameters(selectionParameters.qualifiers, selectionParameters.qualifyingNames, selectionParameters.conditionQualifiers, selectionParameters.conditionQualifyingNames, null, selectionParameters.typeUtils);
    }

    public SelectionParameters(List<TypeMirror> qualifiers, List<String> qualifyingNames, TypeMirror resultType, TypeUtils typeUtils) {
        this(qualifiers, qualifyingNames, Collections.emptyList(), Collections.emptyList(), resultType, typeUtils, null);
    }

    public SelectionParameters(List<TypeMirror> qualifiers, List<String> qualifyingNames, List<TypeMirror> conditionQualifiers, List<String> conditionQualifyingNames, TypeMirror resultType, TypeUtils typeUtils) {
        this(qualifiers, qualifyingNames, conditionQualifiers, conditionQualifyingNames, resultType, typeUtils, null);
    }

    private SelectionParameters(List<TypeMirror> qualifiers, List<String> qualifyingNames, List<TypeMirror> conditionQualifiers, List<String> conditionQualifyingNames, TypeMirror resultType, TypeUtils typeUtils, SourceRHS sourceRHS) {
        this.qualifiers = qualifiers;
        this.qualifyingNames = qualifyingNames;
        this.conditionQualifiers = conditionQualifiers;
        this.conditionQualifyingNames = conditionQualifyingNames;
        this.resultType = resultType;
        this.typeUtils = typeUtils;
        this.sourceRHS = sourceRHS;
    }

    public List<TypeMirror> getQualifiers() {
        return this.qualifiers;
    }

    public List<String> getQualifyingNames() {
        return this.qualifyingNames;
    }

    public List<TypeMirror> getConditionQualifiers() {
        return this.conditionQualifiers;
    }

    public List<String> getConditionQualifyingNames() {
        return this.conditionQualifyingNames;
    }

    public TypeMirror getResultType() {
        return this.resultType;
    }

    public SourceRHS getSourceRHS() {
        return this.sourceRHS;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.qualifyingNames != null ? this.qualifyingNames.hashCode() : 0);
        hash = 97 * hash + (this.resultType != null ? this.resultType.toString().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionParameters other = (SelectionParameters)obj;
        if (!this.equals(this.qualifiers, other.qualifiers)) {
            return false;
        }
        if (!Objects.equals(this.qualifyingNames, other.qualifyingNames)) {
            return false;
        }
        if (!Objects.equals(this.conditionQualifiers, other.conditionQualifiers)) {
            return false;
        }
        if (!Objects.equals(this.conditionQualifyingNames, other.conditionQualifyingNames)) {
            return false;
        }
        if (!Objects.equals(this.sourceRHS, other.sourceRHS)) {
            return false;
        }
        return this.equals(this.resultType, other.resultType);
    }

    private boolean equals(List<TypeMirror> mirrors1, List<TypeMirror> mirrors2) {
        if (mirrors1 == null) {
            return mirrors2 == null;
        }
        if (mirrors2 == null || mirrors1.size() != mirrors2.size()) {
            return false;
        }
        for (int i = 0; i < mirrors1.size(); ++i) {
            if (this.equals(mirrors1.get(i), mirrors2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean equals(TypeMirror mirror1, TypeMirror mirror2) {
        if (mirror1 == null) {
            return mirror2 == null;
        }
        return mirror2 != null && this.typeUtils.isSameType(mirror1, mirror2);
    }

    public SelectionParameters withSourceRHS(SourceRHS sourceRHS) {
        return new SelectionParameters(this.qualifiers, this.qualifyingNames, this.conditionQualifiers, this.conditionQualifyingNames, null, this.typeUtils, sourceRHS);
    }

    public static SelectionParameters forSourceRHS(SourceRHS sourceRHS) {
        return new SelectionParameters(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, sourceRHS);
    }
}

