package org.mapstruct.ap.internal.gem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.tools.gem.Gem;
import org.mapstruct.tools.gem.GemValue;

import javax.lang.model.type.TypeMirror;

public class XmlElementRefGem implements Gem {

    private final GemValue<TypeMirror> type;
    private final GemValue<String> namespace;
    private final GemValue<String> name;
    private final GemValue<Boolean> required;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private XmlElementRefGem( BuilderImpl builder ) {
        this.type = builder.type;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.required = builder.required;
        isValid = ( this.type != null ? this.type.isValid() : false )
               && ( this.namespace != null ? this.namespace.isValid() : false )
               && ( this.name != null ? this.name.isValid() : false )
               && ( this.required != null ? this.required.isValid() : false );
        mirror = builder.mirror;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link XmlElementRefGem#type}
    */
    public GemValue<TypeMirror> type( ) {
        return type;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link XmlElementRefGem#namespace}
    */
    public GemValue<String> namespace( ) {
        return namespace;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link XmlElementRefGem#name}
    */
    public GemValue<String> name( ) {
        return name;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link XmlElementRefGem#required}
    */
    public GemValue<Boolean> required( ) {
        return required;
    }

    @Override
    public AnnotationMirror mirror( ) {
        return mirror;
    }

    @Override
    public boolean isValid( ) {
        return isValid;
    }

    public static XmlElementRefGem  instanceOn(Element element) {
        return build( element, new BuilderImpl() );
    }

    public static XmlElementRefGem instanceOn(AnnotationMirror mirror ) {
        return build( mirror, new BuilderImpl() );
    }

    public static  <T> T  build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream()
            .filter( a ->  "javax.xml.bind.annotation.XmlElementRef".contentEquals( ( ( TypeElement )a.getAnnotationType().asElement() ).getQualifiedName() ) )
            .findAny()
            .orElse( null );
        return build( mirror, builder );
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder ) {

        // return fast
        if ( mirror == null || builder == null ) {
            return null;
        }

        // fetch defaults from all defined values in the annotation type
        List<ExecutableElement> enclosed = ElementFilter.methodsIn( mirror.getAnnotationType().asElement().getEnclosedElements() );
        Map<String, AnnotationValue> defaultValues = new HashMap<>( enclosed.size() );
        enclosed.forEach( e -> defaultValues.put( e.getSimpleName().toString(), e.getDefaultValue() ) );

        // fetch all explicitely set annotation values in the annotation instance
        Map<String, AnnotationValue> values = new HashMap<>( enclosed.size() );
        mirror.getElementValues().entrySet().forEach( e -> values.put( e.getKey().getSimpleName().toString(), e.getValue() ) );

        // iterate and populate builder
        for ( String methodName : defaultValues.keySet() ) {

            if ( "type".equals( methodName ) ) {
                builder.setType( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
            else if ( "namespace".equals( methodName ) ) {
                builder.setNamespace( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "name".equals( methodName ) ) {
                builder.setName( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "required".equals( methodName ) ) {
                builder.setRequired( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), Boolean.class ) );
            }
        }
        builder.setMirror( mirror );
        return builder.build();
    }

    /**
     * A builder that can be implemented by the user to define custom logic e.g. in the
     * build method, prior to creating the annotation gem.
     */
    public interface Builder<T> {

       /**
        * Sets the {@link GemValue} for {@link XmlElementRefGem#type}
        *
        * @return the {@link Builder} for this gem, representing {@link XmlElementRefGem}
        */
        Builder setType(GemValue<TypeMirror> methodName );

       /**
        * Sets the {@link GemValue} for {@link XmlElementRefGem#namespace}
        *
        * @return the {@link Builder} for this gem, representing {@link XmlElementRefGem}
        */
        Builder setNamespace(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link XmlElementRefGem#name}
        *
        * @return the {@link Builder} for this gem, representing {@link XmlElementRefGem}
        */
        Builder setName(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link XmlElementRefGem#required}
        *
        * @return the {@link Builder} for this gem, representing {@link XmlElementRefGem}
        */
        Builder setRequired(GemValue<Boolean> methodName );

        /**
         * Sets the annotation mirror
         *
         * @param mirror the mirror which this gem represents
         *
         * @return the {@link Builder} for this gem, representing {@link XmlElementRefGem}
         */
          Builder setMirror( AnnotationMirror mirror );

        /**
         * The build method can be overriden in a custom custom implementation, which allows
         * the user to define his own custom validation on the annotation.
         *
         * @return the representation of the annotation
         */
        T build();
    }

    private static class BuilderImpl implements Builder<XmlElementRefGem> {

        private GemValue<TypeMirror> type;
        private GemValue<String> namespace;
        private GemValue<String> name;
        private GemValue<Boolean> required;
        private AnnotationMirror mirror;

        public Builder setType(GemValue<TypeMirror> type ) {
            this.type = type;
            return this;
        }

        public Builder setNamespace(GemValue<String> namespace ) {
            this.namespace = namespace;
            return this;
        }

        public Builder setName(GemValue<String> name ) {
            this.name = name;
            return this;
        }

        public Builder setRequired(GemValue<Boolean> required ) {
            this.required = required;
            return this;
        }

        public Builder  setMirror( AnnotationMirror mirror ) {
            this.mirror = mirror;
            return this;
        }

        public XmlElementRefGem build() {
            return new XmlElementRefGem( this );
        }
    }

}
